/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.moolands.world.gen;

import com.legacy.moolands.registry.MoolandsBlocks;
import com.legacy.moolands.world.gen.noise.BetaOctavesNoiseGenerator;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class MoolandChunkGenerator
extends ChunkGenerator<OverworldGenSettings> {
    private Random rand;
    private BetaOctavesNoiseGenerator noise_generator;
    private double[] noise;
    private double[] noiseArray;
    private final OverworldGenSettings settings;
    public static final int CHUNK_SIZE = 16;

    public MoolandChunkGenerator(IWorld world, BiomeProvider biomeProvider, OverworldGenSettings settingsIn) {
        super(world, biomeProvider, (GenerationSettings)settingsIn);
        this.rand = new Random(this.field_222541_b);
        this.noise_generator = new BetaOctavesNoiseGenerator(this.rand, 4);
        this.settings = settingsIn;
    }

    public void func_225551_a_(WorldGenRegion genregion, IChunk chunk) {
        this.replaceBlocksForBiome(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b, chunk, chunk.func_225549_i_());
    }

    public void func_202093_c(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        Biome biome = region.func_226691_t_(new ChunkPos(i, j).func_206849_h());
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202424_a(region.func_72905_C(), i << 4, j << 4);
        WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)i, (int)j, (Random)sharedseedrandom);
    }

    public OverworldGenSettings getSettings() {
        return this.settings;
    }

    public int func_205470_d() {
        return this.field_222540_a.func_181545_F();
    }

    public void func_222537_b(IWorld iWorld, IChunk chunkIn) {
        int x = chunkIn.func_76632_l().field_77276_a;
        int z = chunkIn.func_76632_l().field_77275_b;
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        this.setBlocksInChunk(chunkIn);
    }

    private void setBlocksInChunk(IChunk chunk) {
        this.noiseArray = this.generateNoise(this.noiseArray, chunk.func_76632_l().field_77276_a * 2, chunk.func_76632_l().field_77275_b * 2);
        for (int i1 = 0; i1 < 2; ++i1) {
            for (int j1 = 0; j1 < 2; ++j1) {
                for (int k1 = 0; k1 < 32; ++k1) {
                    double d1 = this.noiseArray[(i1 * 34 + j1) * 33 + k1];
                    double d2 = this.noiseArray[(i1 * 34 + (j1 + 1)) * 33 + k1];
                    double d3 = this.noiseArray[((i1 + 1) * 34 + j1) * 33 + k1];
                    double d4 = this.noiseArray[((i1 + 1) * 34 + (j1 + 1)) * 33 + k1];
                    double d5 = (this.noiseArray[(i1 * 34 + j1) * 33 + (k1 + 1)] - d1) * 0.25;
                    double d6 = (this.noiseArray[(i1 * 34 + (j1 + 1)) * 33 + (k1 + 1)] - d2) * 0.25;
                    double d7 = (this.noiseArray[((i1 + 1) * 34 + j1) * 33 + (k1 + 1)] - d3) * 0.25;
                    double d8 = (this.noiseArray[((i1 + 1) * 34 + (j1 + 1)) * 33 + (k1 + 1)] - d4) * 0.25;
                    for (int l1 = 0; l1 < 4; ++l1) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.125;
                        double d13 = (d4 - d2) * 0.125;
                        for (int i2 = 0; i2 < 8; ++i2) {
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.125;
                            for (int k2 = 0; k2 < 8; ++k2) {
                                int x = i2 + i1 * 8;
                                int z = k2 + j1 * 8;
                                int y = k1 * 4 + l1;
                                BlockState filler = Blocks.field_150350_a.func_176223_P();
                                if (d15 > 0.0) {
                                    filler = MoolandsBlocks.moo_rock.func_176223_P();
                                }
                                BlockPos pos = new BlockPos(x, y, z);
                                if (y >= 0 && y <= 127) {
                                    chunk.func_177436_a(pos, filler, false);
                                }
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
    }

    public BlockPos func_211403_a(World worldIn, String name, BlockPos pos, int radius, boolean p_211403_5_) {
        Structure structure = (Structure)Feature.field_202300_at.get((Object)name.toLowerCase(Locale.ROOT));
        if (structure != null) {
            return structure.func_211405_a(worldIn, (ChunkGenerator)this, pos, radius, p_211403_5_);
        }
        return null;
    }

    private double[] generateNoise(double[] ad, int i, int k) {
        if (ad == null) {
            ad = new double[3366];
        }
        this.noise = this.noise_generator.generateNoiseOctaves(this.noise, i, 0.0, k, 3, 33, 34, 1.0, 1.0, 1.0);
        int id = 0;
        for (int l1 = 0; l1 < 3; ++l1) {
            for (int i2 = 0; i2 < 34; ++i2) {
                for (int j2 = 0; j2 < 33; ++j2) {
                    ad[id] = this.noise[id] + ((double)(j2 / 33) - 0.5);
                    ++id;
                }
            }
        }
        return ad;
    }

    private void replaceBlocksForBiome(int chunkX, int chunkZ, IChunk chunk, BiomeContainer biomeContainer) {
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int i1 = (int)(3.0 + this.rand.nextDouble() * 0.25);
                int j1 = -1;
                BlockState top = MoolandsBlocks.mooland_grass_block.func_176223_P();
                BlockState filler = MoolandsBlocks.mooland_dirt.func_176223_P();
                for (int k1 = 127; k1 >= 0; --k1) {
                    Block block = chunk.func_180495_p(new BlockPos(k, k1, l)).func_177230_c();
                    if (block == Blocks.field_150350_a) {
                        j1 = -1;
                        continue;
                    }
                    if (block != MoolandsBlocks.moo_rock) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            top = Blocks.field_150350_a.func_176223_P();
                            filler = MoolandsBlocks.moo_rock.func_176223_P();
                        }
                        j1 = i1;
                        if (k1 >= 0) {
                            chunk.func_177436_a(new BlockPos(k, k1, l), top, false);
                            continue;
                        }
                        chunk.func_177436_a(new BlockPos(k, k1, l), filler, false);
                        continue;
                    }
                    if (j1 <= 0) continue;
                    --j1;
                    chunk.func_177436_a(new BlockPos(k, k1, l), filler, false);
                }
            }
        }
    }

    public int func_222529_a(int p_222529_1_, int p_222529_2_, Heightmap.Type heightmapType) {
        return 0;
    }
}

