/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.moolands.world.biome.feature;

import com.legacy.moolands.registry.MoolandsBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class BigBlueMushroomFeature
extends Feature<BigMushroomFeatureConfig> {
    public BigBlueMushroomFeature(Function<Dynamic<?>, ? extends BigMushroomFeatureConfig> config) {
        super(config);
    }

    public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, BigMushroomFeatureConfig config) {
        int j;
        boolean largeMushroom = rand.nextInt(4) == 0;
        int mushroomWidth = largeMushroom ? 4 : 2;
        int mushroomHeight = largeMushroom ? 6 : 3;
        int mushroomTopWidth = largeMushroom ? 3 : 1;
        int i = rand.nextInt(3) + 4 + (largeMushroom ? 3 : 0);
        if (rand.nextInt(12) == 0) {
            i *= 2;
        }
        if ((j = pos.func_177956_o()) >= 1 && j + i + 1 < 256) {
            int l2;
            Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (block != MoolandsBlocks.mooland_dirt && block != MoolandsBlocks.mooland_grass_block) {
                return false;
            }
            BlockPos.Mutable mutablePos = new BlockPos.Mutable();
            for (int k = 0; k <= i; ++k) {
                int l = 0;
                if (k < i && k >= i - 3) {
                    l = 2;
                } else if (k == i) {
                    l = 1;
                }
                for (int i1 = -l; i1 <= l; ++i1) {
                    for (int j1 = -l; j1 <= l; ++j1) {
                        BlockState blockstate = worldIn.func_180495_p((BlockPos)mutablePos.func_189533_g((Vec3i)pos).func_196234_d(i1, k, j1));
                        if (blockstate.isAir((IBlockReader)worldIn, (BlockPos)mutablePos) || blockstate.func_203425_a(BlockTags.field_206952_E)) continue;
                        return false;
                    }
                }
            }
            BlockState blockstate1 = (BlockState)MoolandsBlocks.blue_mushroom_block.func_176223_P().func_206870_a((IProperty)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false));
            for (int l1 = i - mushroomHeight; l1 <= i; ++l1) {
                int i2 = l1 < i ? mushroomWidth : mushroomTopWidth;
                for (l2 = -i2; l2 <= i2; ++l2) {
                    for (int k1 = -i2; k1 <= i2; ++k1) {
                        boolean flag5;
                        boolean flag = l2 == -i2;
                        boolean flag1 = l2 == i2;
                        boolean flag2 = k1 == -i2;
                        boolean flag3 = k1 == i2;
                        boolean flag4 = flag || flag1;
                        boolean bl = flag5 = flag2 || flag3;
                        if (l1 < i && flag4 == flag5) continue;
                        mutablePos.func_189533_g((Vec3i)pos).func_196234_d(l2, l1, k1);
                        if (!worldIn.func_180495_p((BlockPos)mutablePos).canBeReplacedByLeaves((IWorldReader)worldIn, (BlockPos)mutablePos)) continue;
                        this.func_202278_a((IWorldWriter)worldIn, (BlockPos)mutablePos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)blockstate1.func_206870_a((IProperty)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(l1 >= i - 1))).func_206870_a((IProperty)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(l2 < 0))).func_206870_a((IProperty)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(l2 > 0))).func_206870_a((IProperty)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(k1 < 0))).func_206870_a((IProperty)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(k1 > 0)));
                    }
                }
            }
            BlockState blockstate2 = (BlockState)((BlockState)Blocks.field_196706_do.func_176223_P().func_206870_a((IProperty)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false));
            for (int j2 = 0; j2 < i; ++j2) {
                if (largeMushroom) {
                    for (l2 = -1; l2 <= 1; ++l2) {
                        for (int k2 = -1; k2 <= 1; ++k2) {
                            mutablePos.func_189533_g((Vec3i)pos).func_189534_c(Direction.UP, j2).func_196234_d(l2, 0, k2);
                            if (!worldIn.func_180495_p((BlockPos)mutablePos).canBeReplacedByLeaves((IWorldReader)worldIn, (BlockPos)mutablePos) && !(worldIn.func_180495_p((BlockPos)mutablePos).func_177230_c() instanceof BushBlock)) continue;
                            this.func_202278_a((IWorldWriter)worldIn, (BlockPos)mutablePos, blockstate2);
                        }
                    }
                    continue;
                }
                mutablePos.func_189533_g((Vec3i)pos).func_189534_c(Direction.UP, j2);
                if (!worldIn.func_180495_p((BlockPos)mutablePos).canBeReplacedByLeaves((IWorldReader)worldIn, (BlockPos)mutablePos)) continue;
                this.func_202278_a((IWorldWriter)worldIn, (BlockPos)mutablePos, blockstate2);
            }
            return true;
        }
        return false;
    }
}

