/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.moolands.block;

import com.google.common.cache.LoadingCache;
import com.legacy.moolands.registry.MoolandsBlocks;
import com.legacy.moolands.registry.MoolandsDimensions;
import com.legacy.moolands.util.ObfuscationShortcuts;
import com.legacy.moolands.world.teleporter.MooTeleporter;
import java.lang.reflect.Field;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class MoolandPortalBlock
extends NetherPortalBlock {
    private static final Field defaultTeleporter = ObfuscationReflectionHelper.findField(ServerWorld.class, (String)"field_85177_Q");

    public MoolandPortalBlock(Block state) {
        super(Block.Properties.func_200945_a((Material)Material.field_151567_E).func_200942_a().func_200944_c().func_200943_b(-1.0f).func_200947_a(SoundType.field_185853_f).func_200951_a(11).func_222380_e());
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        super.func_225534_a_(state, worldIn, pos, random);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 2; ++i) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (float)pos.func_177956_o() + rand.nextFloat();
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            int j = rand.nextInt(2) * 2 - 1;
            if (worldIn.func_180495_p(pos.func_177976_e()).func_177230_c() != this && worldIn.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)j;
            } else {
                d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)j;
            }
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197613_f, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.func_201670_d() && this.canEntityTravel(entity)) {
            if (entity.field_71088_bW > 0) {
                entity.field_71088_bW = entity.func_82147_ab();
            } else {
                DimensionType destDim = world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_ ? MoolandsDimensions.moolandsType() : DimensionType.field_223227_a_;
                ServerWorld destWorld = world.func_73046_m().func_71218_a(destDim);
                Teleporter oldDefaultTp = destWorld.func_85176_s();
                ObfuscationShortcuts.setObfuscatedValue(defaultTeleporter, destWorld, (Object)new MooTeleporter(world.func_73046_m().func_71218_a(destDim), this));
                MooTeleporter.setLastPortalVec(pos, entity, this);
                entity.field_71088_bW = 500;
                entity.func_212321_a(destDim);
                ObfuscationShortcuts.setObfuscatedValue(defaultTeleporter, destWorld, oldDefaultTp);
            }
        }
    }

    private boolean canEntityTravel(Entity entity) {
        return !entity.func_184207_aI() && entity.func_184187_bx() == null && entity.func_184222_aU();
    }

    public boolean func_176548_d(IWorld worldIn, BlockPos pos) {
        Size blockportal$size = new Size(worldIn, pos, Direction.Axis.X);
        if (blockportal$size.isValid() && blockportal$size.portalBlockCount == 0) {
            blockportal$size.placePortalBlocks();
            return true;
        }
        Size blockportal$size1 = new Size(worldIn, pos, Direction.Axis.Z);
        if (blockportal$size1.isValid() && blockportal$size1.portalBlockCount == 0) {
            blockportal$size1.placePortalBlocks();
            return true;
        }
        return false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction.Axis direction$axis = facing.func_176740_k();
        Direction.Axis direction$axis1 = (Direction.Axis)stateIn.func_177229_b((IProperty)field_176550_a);
        boolean flag = direction$axis1 != direction$axis && direction$axis.func_176722_c();
        return !flag && facingState.func_177230_c() != MoolandsBlocks.mooland_portal && !new Size(worldIn, currentPos, direction$axis1).func_208508_f() ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Size blockportal$size1;
        Direction.Axis enumfacing$axis = (Direction.Axis)state.func_177229_b((IProperty)field_176550_a);
        if (enumfacing$axis == Direction.Axis.X) {
            Size blockportal$size = new Size((IWorld)worldIn, pos, Direction.Axis.X);
            if (!blockportal$size.isValid() || blockportal$size.portalBlockCount < blockportal$size.width * blockportal$size.height) {
                worldIn.func_175655_b(pos, false);
            }
        } else if (!(enumfacing$axis != Direction.Axis.Z || (blockportal$size1 = new Size((IWorld)worldIn, pos, Direction.Axis.Z)).isValid() && blockportal$size1.portalBlockCount >= blockportal$size1.width * blockportal$size1.height)) {
            worldIn.func_175655_b(pos, false);
        }
    }

    public static BlockPattern.PatternHelper createPatternHelper(IWorld worldIn, BlockPos p_181089_2_) {
        Direction.Axis direction$axis = Direction.Axis.Z;
        Size netherportalblock$size = new Size(worldIn, p_181089_2_, Direction.Axis.X);
        LoadingCache loadingcache = BlockPattern.func_181627_a((IWorldReader)worldIn, (boolean)true);
        if (!netherportalblock$size.isValid()) {
            direction$axis = Direction.Axis.X;
            netherportalblock$size = new Size(worldIn, p_181089_2_, Direction.Axis.Z);
        }
        if (!netherportalblock$size.isValid()) {
            return new BlockPattern.PatternHelper(p_181089_2_, Direction.NORTH, Direction.UP, loadingcache, 1, 1, 1);
        }
        int[] aint = new int[Direction.AxisDirection.values().length];
        Direction direction = netherportalblock$size.rightDir.func_176735_f();
        BlockPos blockpos = netherportalblock$size.bottomLeft.func_177981_b(netherportalblock$size.getHeight() - 1);
        for (Direction.AxisDirection direction$axisdirection : Direction.AxisDirection.values()) {
            BlockPattern.PatternHelper blockpattern$patternhelper = new BlockPattern.PatternHelper(direction.func_176743_c() == direction$axisdirection ? blockpos : blockpos.func_177967_a(netherportalblock$size.rightDir, netherportalblock$size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)direction$axisdirection, (Direction.Axis)direction$axis), Direction.UP, loadingcache, netherportalblock$size.getWidth(), netherportalblock$size.getHeight(), 1);
            for (int i = 0; i < netherportalblock$size.getWidth(); ++i) {
                for (int j = 0; j < netherportalblock$size.getHeight(); ++j) {
                    CachedBlockInfo cachedblockinfo = blockpattern$patternhelper.func_177670_a(i, j, 1);
                    if (cachedblockinfo.func_177509_a().func_196958_f()) continue;
                    int n = direction$axisdirection.ordinal();
                    aint[n] = aint[n] + 1;
                }
            }
        }
        Direction.AxisDirection direction$axisdirection1 = Direction.AxisDirection.POSITIVE;
        for (Direction.AxisDirection direction$axisdirection2 : Direction.AxisDirection.values()) {
            if (aint[direction$axisdirection2.ordinal()] >= aint[direction$axisdirection1.ordinal()]) continue;
            direction$axisdirection1 = direction$axisdirection2;
        }
        return new BlockPattern.PatternHelper(direction.func_176743_c() == direction$axisdirection1 ? blockpos : blockpos.func_177967_a(netherportalblock$size.rightDir, netherportalblock$size.getWidth() - 1), Direction.func_181076_a((Direction.AxisDirection)direction$axisdirection1, (Direction.Axis)direction$axis), Direction.UP, loadingcache, netherportalblock$size.getWidth(), netherportalblock$size.getHeight(), 1);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockState frame_block = Blocks.field_150426_aN.func_176223_P();
        for (int y = -1; y <= 3; ++y) {
            if (placer.func_174811_aO() == Direction.NORTH || placer.func_174811_aO() == Direction.SOUTH) {
                for (int x = -1; x <= 2; ++x) {
                    worldIn.func_180501_a(pos.func_177982_a(x, y, 0), frame_block, 18);
                }
                continue;
            }
            for (int z = -1; z <= 2; ++z) {
                worldIn.func_180501_a(pos.func_177982_a(0, y, z), frame_block, 18);
            }
        }
        for (int y1 = 0; y1 <= 2; ++y1) {
            if (placer.func_174811_aO() == Direction.NORTH || placer.func_174811_aO() == Direction.SOUTH) {
                for (int x1 = 0; x1 <= 1; ++x1) {
                    worldIn.func_180501_a(pos.func_177982_a(x1, y1, 0), (BlockState)MoolandsBlocks.mooland_portal.func_176223_P().func_206870_a((IProperty)field_176550_a, (Comparable)Direction.Axis.X), 18);
                }
                continue;
            }
            for (int z1 = 0; z1 <= 1; ++z1) {
                worldIn.func_180501_a(pos.func_177982_a(0, y1, z1), (BlockState)MoolandsBlocks.mooland_portal.func_176223_P().func_206870_a((IProperty)field_176550_a, (Comparable)Direction.Axis.Z), 18);
            }
        }
    }

    public Size isSkyPortal(IWorld p_201816_1_, BlockPos p_201816_2_) {
        Size netherportalblock$size = new Size(p_201816_1_, p_201816_2_, Direction.Axis.X);
        if (netherportalblock$size.isValid() && netherportalblock$size.portalBlockCount == 0) {
            return netherportalblock$size;
        }
        Size netherportalblock$size1 = new Size(p_201816_1_, p_201816_2_, Direction.Axis.Z);
        return netherportalblock$size1.isValid() && netherportalblock$size1.portalBlockCount == 0 ? netherportalblock$size1 : null;
    }

    public static class Size {
        private final IWorld world;
        private final Direction.Axis axis;
        private final Direction rightDir;
        private final Direction leftDir;
        private int portalBlockCount;
        @Nullable
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public Size(IWorld p_i48740_1_, BlockPos p_i48740_2_, Direction.Axis p_i48740_3_) {
            this.world = p_i48740_1_;
            this.axis = p_i48740_3_;
            if (p_i48740_3_ == Direction.Axis.X) {
                this.leftDir = Direction.EAST;
                this.rightDir = Direction.WEST;
            } else {
                this.leftDir = Direction.NORTH;
                this.rightDir = Direction.SOUTH;
            }
            BlockPos blockpos = p_i48740_2_;
            while (p_i48740_2_.func_177956_o() > blockpos.func_177956_o() - 21 && p_i48740_2_.func_177956_o() > 0 && this.func_196900_a(p_i48740_1_.func_180495_p(p_i48740_2_.func_177977_b()))) {
                p_i48740_2_ = p_i48740_2_.func_177977_b();
            }
            int i = this.getDistanceUntilEdge(p_i48740_2_, this.leftDir) - 1;
            if (i >= 0) {
                this.bottomLeft = p_i48740_2_.func_177967_a(this.leftDir, i);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos p_180120_1_, Direction p_180120_2_) {
            BlockPos blockpos;
            int i;
            for (i = 0; i < 22 && this.func_196900_a(this.world.func_180495_p(blockpos = p_180120_1_.func_177967_a(p_180120_2_, i))) && this.world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150426_aN; ++i) {
            }
            Block block = this.world.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i)).func_177230_c();
            return block == Blocks.field_150426_aN ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    BlockState blockstate = this.world.func_180495_p(blockpos);
                    if (!this.func_196900_a(blockstate)) break block0;
                    Block block = blockstate.func_177230_c();
                    if (block == MoolandsBlocks.mooland_portal) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0 ? (block = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir)).func_177230_c()) != Blocks.field_150426_aN : i == this.width - 1 && (block = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir)).func_177230_c()) != Blocks.field_150426_aN) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                if (this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height)).func_177230_c() == Blocks.field_150426_aN) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean func_196900_a(BlockState p_196900_1_) {
            Block block = p_196900_1_.func_177230_c();
            return p_196900_1_.func_196958_f() || block == Blocks.field_150480_ab || block == MoolandsBlocks.mooland_portal || block == Blocks.field_150350_a;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), (BlockState)MoolandsBlocks.mooland_portal.func_176223_P().func_206870_a((IProperty)field_176550_a, (Comparable)this.axis), 18);
                }
            }
        }

        private boolean func_196899_f() {
            return this.portalBlockCount >= this.width * this.height;
        }

        public boolean func_208508_f() {
            return this.isValid() && this.func_196899_f();
        }
    }
}

