/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.moolands.world.teleporter;

import com.google.common.collect.Maps;
import com.legacy.moolands.block.MoolandPortalBlock;
import com.legacy.moolands.util.ObfuscationShortcuts;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.ColumnPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.Teleporter;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class MooTeleporter
extends Teleporter {
    protected final Map<ColumnPos, PortalPosition> field_85191_c = Maps.newHashMapWithExpectedSize((int)4096);
    private final Object2LongMap<ColumnPos> columnPosMap = new Object2LongOpenHashMap();
    private final MoolandPortalBlock portalBlock;
    public static Field lastPortalVec = ObfuscationReflectionHelper.findField(Entity.class, (String)"field_181017_ao");

    public MooTeleporter(ServerWorld worldIn, MoolandPortalBlock portalBlock) {
        super(worldIn);
        this.portalBlock = portalBlock;
    }

    public boolean func_222268_a(Entity entity, float yaw) {
        BlockPattern.PatternHelper patternHelper = this.portalBlock.func_181089_f((IWorld)this.field_85192_a, entity.func_180425_c());
        double d0 = patternHelper.func_177669_b().func_176740_k() == Direction.Axis.X ? (double)patternHelper.func_181117_a().func_177952_p() : (double)patternHelper.func_181117_a().func_177958_n();
        double d1 = Math.abs(MathHelper.func_181160_c((double)((patternHelper.func_177669_b().func_176740_k() == Direction.Axis.X ? entity.field_70165_t : entity.field_70165_t) - (double)(patternHelper.func_177669_b().func_176746_e().func_176743_c() == Direction.AxisDirection.NEGATIVE ? 1 : 0)), (double)d0, (double)(d0 - (double)patternHelper.func_181118_d())));
        double d2 = MathHelper.func_181160_c((double)(entity.field_70163_u - 1.0), (double)patternHelper.func_181117_a().func_177956_o(), (double)(patternHelper.func_181117_a().func_177956_o() - patternHelper.func_181119_e()));
        Vec3d posVec = new Vec3d(d1, d2, 0.0);
        Direction direction = patternHelper.func_177669_b();
        BlockPattern.PortalInfo portalInfo = this.func_222272_a(new BlockPos(entity), entity.func_213322_ci(), direction, posVec.field_72450_a, posVec.field_72448_b, entity instanceof PlayerEntity);
        if (portalInfo == null) {
            return false;
        }
        Vec3d portalPos = portalInfo.field_222505_a;
        Vec3d portalMotion = portalInfo.field_222506_b;
        entity.func_213317_d(portalMotion);
        entity.field_70177_z = yaw + (float)portalInfo.field_222507_c;
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147364_a(portalPos.field_72450_a, portalPos.field_72448_b, portalPos.field_72449_c, entity.field_70177_z, entity.field_70125_A);
            ((ServerPlayerEntity)entity).field_71135_a.func_184342_d();
        } else {
            entity.func_70012_b(portalPos.field_72450_a, portalPos.field_72448_b, portalPos.field_72449_c, entity.field_70177_z, entity.field_70125_A);
        }
        if (entity instanceof LivingEntity) {
            entity.field_70172_ad = 20;
        }
        return true;
    }

    public static void setLastPortalVec(BlockPos pos, Entity entity, MoolandPortalBlock portal) {
        BlockPattern.PatternHelper patternHelper = portal.func_181089_f((IWorld)entity.func_130014_f_(), pos);
        double d0 = patternHelper.func_177669_b().func_176740_k() == Direction.Axis.X ? (double)patternHelper.func_181117_a().func_177952_p() : (double)patternHelper.func_181117_a().func_177958_n();
        double d1 = Math.abs(MathHelper.func_181160_c((double)((patternHelper.func_177669_b().func_176740_k() == Direction.Axis.X ? entity.field_70161_v : entity.field_70165_t) - (double)(patternHelper.func_177669_b().func_176746_e().func_176743_c() == Direction.AxisDirection.NEGATIVE ? 1 : 0)), (double)d0, (double)(d0 - (double)patternHelper.func_181118_d())));
        double d2 = MathHelper.func_181160_c((double)(entity.field_70163_u - 1.0), (double)patternHelper.func_181117_a().func_177956_o(), (double)(patternHelper.func_181117_a().func_177956_o() - patternHelper.func_181119_e()));
        ObfuscationShortcuts.setObfuscatedValue(lastPortalVec, entity, new Vec3d(d1, d2, 0.0));
    }

    @Nullable
    public BlockPattern.PortalInfo func_222272_a(BlockPos pos, Vec3d motionVec, Direction directionIn, double xIn, double yIn, boolean isPlayer) {
        boolean flag = true;
        BlockPos blockPos = null;
        ColumnPos columnpos = new ColumnPos(pos);
        if (!isPlayer && this.columnPosMap.containsKey((Object)columnpos)) {
            return null;
        }
        PortalPosition portalPos = this.field_85191_c.get(columnpos);
        if (portalPos != null) {
            blockPos = portalPos.pos;
            portalPos.lastUpdateTime = this.field_85192_a.func_82737_E();
            flag = false;
        } else {
            int range = 32;
            BlockPos prevPos = null;
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    for (int y = 0; y < 255; ++y) {
                        BlockPos currentPos = new BlockPos(pos.func_177958_n() + x, y, pos.func_177952_p() + z);
                        if (this.field_85192_a.func_180495_p(currentPos).func_177230_c() != this.portalBlock || this.field_85192_a.func_180495_p(currentPos.func_177977_b()).func_177230_c() == this.portalBlock) continue;
                        if (prevPos == null) {
                            prevPos = currentPos;
                            continue;
                        }
                        if (!(MooTeleporter.getDistance(prevPos, pos) > MooTeleporter.getDistance(currentPos, pos))) continue;
                        prevPos = currentPos;
                    }
                }
            }
            blockPos = prevPos;
        }
        if (blockPos == null) {
            long l = this.field_85192_a.func_82737_E() + 300L;
            this.columnPosMap.put((Object)columnpos, l);
            return null;
        }
        if (flag) {
            this.field_85191_c.put(columnpos, new PortalPosition(blockPos, this.field_85192_a.func_82737_E()));
            this.field_85192_a.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(blockPos), 3, (Object)columnpos);
        }
        BlockPattern.PatternHelper patternHelper = this.portalBlock.func_181089_f((IWorld)this.field_85192_a, blockPos);
        return patternHelper.func_222504_a(directionIn, blockPos, yIn, motionVec, xIn);
    }

    public boolean func_85188_a(Entity entityIn) {
        BlockPos pos = entityIn.func_180425_c();
        double d0 = -1.0;
        int x = MathHelper.func_76141_d((float)pos.func_177958_n());
        int y = MathHelper.func_76141_d((float)pos.func_177956_o());
        int z = MathHelper.func_76141_d((float)pos.func_177952_p());
        int i1 = x;
        int j1 = y;
        int k1 = z;
        int l1 = 0;
        int i2 = this.field_85192_a.field_73012_v.nextInt(4);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int j2 = x - 16; j2 <= x + 16; ++j2) {
            double d1 = (double)j2 + 0.5 - (double)pos.func_177958_n();
            for (int l2 = z - 16; l2 <= z + 16; ++l2) {
                double d2 = (double)l2 + 0.5 - (double)pos.func_177952_p();
                block2: for (int j3 = this.field_85192_a.func_72940_L() - 1; j3 >= 0; --j3) {
                    if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3, l2))) continue;
                    while (j3 > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(j2, j3 - 1, l2))) {
                        --j3;
                    }
                    for (int k3 = i2; k3 < i2 + 4; ++k3) {
                        int l3 = k3 % 2;
                        int i4 = 1 - l3;
                        if (k3 % 4 >= 2) {
                            l3 = -l3;
                            i4 = -i4;
                        }
                        for (int j4 = 0; j4 < 3; ++j4) {
                            for (int k4 = 0; k4 < 4; ++k4) {
                                for (int l4 = -1; l4 < 4; ++l4) {
                                    int i5 = j2 + (k4 - 1) * l3 + j4 * i4;
                                    int j5 = j3 + l4;
                                    int k5 = l2 + (k4 - 1) * i4 - j4 * l3;
                                    blockpos$mutableblockpos.func_181079_c(i5, j5, k5);
                                    if (l4 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() || l4 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block2;
                                }
                            }
                        }
                        double d5 = (double)j3 + 0.5 - (double)pos.func_177956_o();
                        double d7 = d1 * d1 + d5 * d5 + d2 * d2;
                        if (!(d0 < 0.0) && !(d7 < d0)) continue;
                        d0 = d7;
                        i1 = j2;
                        j1 = j3;
                        k1 = l2;
                        l1 = k3 % 4;
                    }
                }
            }
        }
        if (d0 < 0.0) {
            for (int l5 = x - 16; l5 <= x + 16; ++l5) {
                double d3 = (double)l5 + 0.5 - (double)pos.func_177958_n();
                for (int j6 = z - 16; j6 <= z + 16; ++j6) {
                    double d4 = (double)j6 + 0.5 - (double)pos.func_177956_o();
                    block10: for (int i7 = this.field_85192_a.func_72940_L() - 1; i7 >= 0; --i7) {
                        if (!this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7, j6))) continue;
                        while (i7 > 0 && this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos.func_181079_c(l5, i7 - 1, j6))) {
                            --i7;
                        }
                        for (int l7 = i2; l7 < i2 + 2; ++l7) {
                            int l8 = l7 % 2;
                            int k9 = 1 - l8;
                            for (int i10 = 0; i10 < 4; ++i10) {
                                for (int k10 = -1; k10 < 4; ++k10) {
                                    int i11 = l5 + (i10 - 1) * l8;
                                    int j11 = i7 + k10;
                                    int k11 = j6 + (i10 - 1) * k9;
                                    blockpos$mutableblockpos.func_181079_c(i11, j11, k11);
                                    if (k10 < 0 && !this.field_85192_a.func_180495_p((BlockPos)blockpos$mutableblockpos).func_185904_a().func_76220_a() || k10 >= 0 && !this.field_85192_a.func_175623_d((BlockPos)blockpos$mutableblockpos)) continue block10;
                                }
                            }
                            double d6 = (double)i7 + 0.5 - (double)pos.func_177956_o();
                            double d8 = d3 * d3 + d6 * d6 + d4 * d4;
                            if (!(d0 < 0.0) && !(d8 < d0)) continue;
                            d0 = d8;
                            i1 = l5;
                            j1 = i7;
                            k1 = j6;
                            l1 = l7 % 2;
                        }
                    }
                }
            }
        }
        int i6 = i1;
        int k2 = j1;
        int k6 = k1;
        int l6 = l1 % 2;
        int i3 = 1 - l6;
        if (l1 % 4 >= 2) {
            l6 = -l6;
            i3 = -i3;
        }
        if (d0 < 0.0) {
            k2 = j1 = MathHelper.func_76125_a((int)j1, (int)70, (int)(this.field_85192_a.func_72940_L() - 10));
            for (int j7 = -1; j7 <= 1; ++j7) {
                for (int i8 = 1; i8 < 3; ++i8) {
                    for (int i9 = -1; i9 < 3; ++i9) {
                        int l9 = i6 + (i8 - 1) * l6 + j7 * i3;
                        int j10 = k2 + i9;
                        int l10 = k6 + (i8 - 1) * i3 - j7 * l6;
                        boolean flag = i9 < 0;
                        blockpos$mutableblockpos.func_181079_c(l9, j10, l10);
                        this.field_85192_a.func_175656_a((BlockPos)blockpos$mutableblockpos, flag ? Blocks.field_150426_aN.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
        }
        for (int k7 = -1; k7 < 3; ++k7) {
            for (int j8 = -1; j8 < 4; ++j8) {
                if (k7 != -1 && k7 != 2 && j8 != -1 && j8 != 3) continue;
                blockpos$mutableblockpos.func_181079_c(i6 + k7 * l6, k2 + j8, k6 + k7 * i3);
                this.field_85192_a.func_180501_a((BlockPos)blockpos$mutableblockpos, Blocks.field_150426_aN.func_176223_P(), 3);
            }
        }
        BlockState blockstate = (BlockState)this.portalBlock.func_176223_P().func_206870_a((IProperty)MoolandPortalBlock.field_176550_a, (Comparable)(l6 == 0 ? Direction.Axis.Z : Direction.Axis.X));
        for (int k8 = 0; k8 < 2; ++k8) {
            for (int j9 = 0; j9 < 3; ++j9) {
                blockpos$mutableblockpos.func_181079_c(i6 + k8 * l6, k2 + j9, k6 + k8 * i3);
                this.field_85192_a.func_180501_a((BlockPos)blockpos$mutableblockpos, blockstate, 18);
            }
        }
        return true;
    }

    public void func_85189_a(long worldTime) {
        if (worldTime % 100L == 0L) {
            this.removeStaleColumnPositions(worldTime);
            this.removeStalePortalLocations(worldTime);
        }
    }

    private void removeStaleColumnPositions(long lastUpdateTime) {
        LongIterator longiterator = this.columnPosMap.values().iterator();
        while (longiterator.hasNext()) {
            long i = longiterator.nextLong();
            if (i > lastUpdateTime) continue;
            longiterator.remove();
        }
    }

    private void removeStalePortalLocations(long lastUpdateTime) {
        long i = lastUpdateTime - 300L;
        Iterator<Map.Entry<ColumnPos, PortalPosition>> iterator = this.field_85191_c.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ColumnPos, PortalPosition> entry = iterator.next();
            PortalPosition portalPos = entry.getValue();
            if (portalPos.lastUpdateTime >= i) continue;
            ColumnPos columnpos = entry.getKey();
            this.field_85192_a.func_72863_F().func_217228_a(TicketType.field_219493_f, new ChunkPos(portalPos.pos), 3, (Object)columnpos);
            iterator.remove();
        }
    }

    private static double getDistance(BlockPos a, BlockPos b) {
        if (a == null || b == null) {
            return 0.0;
        }
        double x = b.func_177958_n() - a.func_177958_n();
        double y = b.func_177956_o() - a.func_177956_o();
        double z = b.func_177952_p() - a.func_177952_p();
        return Math.sqrt(x * x + y * y + z * z);
    }

    static class PortalPosition {
        public final BlockPos pos;
        public long lastUpdateTime;

        public PortalPosition(BlockPos pos, long lastUpdateTime) {
            this.pos = pos;
            this.lastUpdateTime = lastUpdateTime;
        }
    }
}

