/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.moolands.registry;

import com.legacy.moolands.Moolands;
import com.legacy.moolands.client.SoundsMoolands;
import com.legacy.moolands.item.ItemMooRecord;
import com.legacy.moolands.item.group.MoolandsItemGroup;
import com.legacy.moolands.registry.MoolandsBiomes;
import com.legacy.moolands.registry.MoolandsBlocks;
import com.legacy.moolands.registry.MoolandsChunkGeneratorTypes;
import com.legacy.moolands.registry.MoolandsDimensions;
import com.legacy.moolands.registry.MoolandsEntityTypes;
import com.legacy.moolands.registry.MoolandsFeatures;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="moolands", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MoolandsRegistry {
    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        MoolandsBlocks.init(event);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        MoolandsRegistry.register(event.getRegistry(), "awful_cow_spawn_egg", new SpawnEggItem(MoolandsEntityTypes.AWFUL_COW, 3365276, 13946167, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)));
        MoolandsRegistry.register(event.getRegistry(), "moo_disc", new ItemMooRecord(SoundsMoolands.MOO_DISC, new Item.Properties().func_200917_a(1).func_200916_a((ItemGroup)MoolandsItemGroup.ALL).func_208103_a(Rarity.EPIC)));
        for (Map.Entry<Block, ItemGroup> entry : MoolandsBlocks.blockItemMap.entrySet()) {
            MoolandsRegistry.register(event.getRegistry(), entry.getKey().getRegistryName().func_110623_a(), new BlockItem(entry.getKey(), new Item.Properties().func_200916_a(entry.getValue())));
        }
        MoolandsBlocks.blockItemMap.clear();
        for (Map.Entry<Block, ItemGroup> entry : MoolandsBlocks.blockItemPropertiesMap.entrySet()) {
            MoolandsRegistry.register(event.getRegistry(), entry.getKey().getRegistryName().func_110623_a(), new BlockItem(entry.getKey(), (Item.Properties)entry.getValue()));
        }
        MoolandsBlocks.blockItemPropertiesMap.clear();
    }

    @SubscribeEvent
    public static void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        MoolandsEntityTypes.init(event);
    }

    @SubscribeEvent
    public static void onRegisterSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        MoolandsRegistry.register(event.getRegistry(), "cow_ambient", SoundsMoolands.COW_AMBIENT);
        MoolandsRegistry.register(event.getRegistry(), "cow_hurt", SoundsMoolands.COW_HURT);
        MoolandsRegistry.register(event.getRegistry(), "cow_death", SoundsMoolands.COW_DEATH);
        MoolandsRegistry.register(event.getRegistry(), "moo_disc", SoundsMoolands.MOO_DISC);
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        MoolandsFeatures.init(event);
    }

    @SubscribeEvent
    public static void onRegisterBiomes(RegistryEvent.Register<Biome> event) {
        MoolandsBiomes.init(event);
    }

    @SubscribeEvent
    public static void onRegisterDimensions(RegistryEvent.Register<ModDimension> event) {
        MoolandsDimensions.init(event);
    }

    @SubscribeEvent
    public static void registerChunkGeneratorTypes(RegistryEvent.Register<ChunkGeneratorType<?, ?>> event) {
        MoolandsChunkGeneratorTypes.init(event);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String name, T object) {
        object.setRegistryName(Moolands.locate(name));
        registry.register(object);
    }
}

