/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.sound;

import java.util.HashSet;
import java.util.Set;
import me.andre111.mambience.config.EngineConfig;
import me.andre111.mambience.player.MAPlayer;
import me.andre111.mambience.script.MAScriptEngine;
import me.andre111.mambience.script.MAScripting;

public class Soundscape {
    private Set<SoundInfo> sounds = new HashSet<SoundInfo>();
    private boolean initialised = false;

    public void initGlobal() {
        MAScriptEngine se = MAScriptEngine.getInstance();
        for (SoundInfo si : this.sounds) {
            si.init(se);
        }
        this.initialised = true;
    }

    public void init(MAPlayer maplayer) {
        MAScriptEngine se = MAScriptEngine.getInstance();
        for (SoundInfo si : this.sounds) {
            this.startCooldown(maplayer, se, si);
        }
    }

    public void update(MAPlayer maplayer) {
        if (!this.initialised) {
            return;
        }
        MAScriptEngine se = MAScriptEngine.getInstance();
        for (SoundInfo si : this.sounds) {
            if (this.conditionsMet(se, si)) {
                if (maplayer.updateCooldown(si.getName()) > 0) continue;
                float volume = ((Number)se.invokeFunction("Internal_Volume_" + si.getName())).floatValue() * EngineConfig.GLOBALVOLUME;
                float pitch = ((Number)se.invokeFunction("Internal_Pitch_" + si.getName())).floatValue();
                maplayer.getLogger().log("Play sound " + si.getSound() + " at " + volume);
                maplayer.getAccessor().playSound(si.getSound(), volume, pitch);
                this.startCooldown(maplayer, se, si);
                continue;
            }
            if (!EngineConfig.STOPSOUNDS || maplayer.getCooldown(si.getName()) <= 0) continue;
            maplayer.getLogger().log("Stop sound " + si.getSound());
            maplayer.getAccessor().stopSound(si.getSound());
            maplayer.setCooldown(si.getName(), 0);
        }
    }

    private boolean conditionsMet(MAScriptEngine se, SoundInfo si) {
        return this.getBooleanFunctionResult(se, "Internal_Function_" + si.getName());
    }

    private boolean getBooleanFunctionResult(MAScriptEngine se, String name) {
        Object value = se.invokeFunction(name);
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 0;
        }
        return false;
    }

    private int getIntFunctionResult(MAScriptEngine se, String name) {
        Object value = se.invokeFunction(name);
        if (value == null) {
            return 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return 0;
    }

    private void startCooldown(MAPlayer maplayer, MAScriptEngine se, SoundInfo si) {
        maplayer.setCooldown(si.getName(), this.getIntFunctionResult(se, "Internal_Cooldown_" + si.getName()));
    }

    public void addSound(SoundInfo sound) {
        this.sounds.add(sound);
    }

    public static class SoundInfo {
        private String name;
        private String sound;
        private String conditions;
        private String restrictions = "false";
        private String volume = "1.0";
        private String pitch = "1.0";
        private String cooldown;

        private void init(MAScriptEngine se) {
            se.compileScript("function Internal_Function_" + this.name + "() {   return (" + this.getConditions() + ")" + (this.getRestrictions().equals("") ? ";" : " && !(" + this.getRestrictions() + ");") + "}function Internal_Cooldown_" + this.name + "() {   return " + this.getCooldown() + ";}function Internal_Volume_" + this.name + "() {   return " + this.getVolume() + ";}function Internal_Pitch_" + this.name + "() {   return " + this.getPitch() + ";}");
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSound() {
            return this.sound;
        }

        public void setSound(String sound) {
            this.sound = sound;
        }

        public String getConditions() {
            return this.conditions;
        }

        public void setConditions(String conditions) {
            this.conditions = MAScripting.expandMacros(conditions);
        }

        public String getRestrictions() {
            return this.restrictions;
        }

        public void setRestrictions(String restrictions) {
            this.restrictions = MAScripting.expandMacros(restrictions);
        }

        public String getVolume() {
            return this.volume;
        }

        public void setVolume(String volume) {
            this.volume = MAScripting.expandMacros(volume);
        }

        public String getPitch() {
            return this.pitch;
        }

        public void setPitch(String pitch) {
            this.pitch = MAScripting.expandMacros(pitch);
        }

        public String getCooldown() {
            return this.cooldown;
        }

        public void setCooldown(String cooldown) {
            this.cooldown = MAScripting.expandMacros(cooldown);
        }
    }
}

