/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.script;

import java.util.ArrayList;

public class MAScripting {
    private static ArrayList<Macro> macros = new ArrayList();

    public static String expandMacros(String js) {
        for (Macro macro : macros) {
            js = macro.expand(js);
        }
        return js;
    }

    public static void addMacro(String name, String content) {
        Macro macro = new Macro();
        macro.name = "#" + name + "#";
        macro.content = content;
        macros.add(macro);
    }

    private static class Macro {
        private String name;
        private String content;

        private Macro() {
        }

        public String expand(String js) {
            if (!js.contains(this.name)) {
                return js;
            }
            String currentContent = this.content;
            if (currentContent.contains("#")) {
                for (Macro macro : macros) {
                    if (macro.name.equals(this.name)) continue;
                    currentContent = macro.expand(currentContent);
                }
            }
            js = js.replace(this.name, currentContent);
            return js;
        }
    }
}

