/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.resources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class RPGenerator {
    public static void main(String[] args) {
        try {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            Path path = Paths.get("./Mambience-" + RPGenerator.getVersion() + "-resources.zip", new String[0]);
            Files.deleteIfExists(path);
            URI uri = URI.create("jar:" + path.toUri());
            try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
                RPGenerator.transferFile("/pack_template.mcmeta", fs.getPath("/pack.mcmeta", new String[0]));
                RPGenerator.transferFile("/pack.png", fs.getPath("/pack.png", new String[0]));
                Set<String> filePaths = RPGenerator.getResourceFiles("assets/");
                for (String filePath : filePaths) {
                    RPGenerator.transferFile("/" + filePath, fs.getPath("/" + filePath, new String[0]));
                }
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    private static String getVersion() throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(RPGenerator.class.getResourceAsStream("/version.txt"), "UTF-8"));){
            String string = reader.readLine();
            return string;
        }
    }

    private static Set<String> getResourceFiles(String startPath) throws IOException {
        String me = RPGenerator.class.getName().replace(".", "/") + ".class";
        URL dirURL = RPGenerator.class.getClassLoader().getResource(me);
        if (dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));){
                Enumeration<JarEntry> entries = jar.entries();
                HashSet<String> result = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(startPath)) continue;
                    result.add(name);
                }
                HashSet<String> hashSet = result;
                return hashSet;
            }
        }
        throw new UnsupportedOperationException("Can only extract resources from jar file!");
    }

    private static void transferFile(String sourcePath, Path targetPath) throws IOException {
        if (Files.isDirectory(targetPath, new LinkOption[0])) {
            return;
        }
        try (InputStream is = RPGenerator.class.getResourceAsStream(sourcePath);){
            if (!Files.exists(targetPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
            }
            Files.copy(is, targetPath, new CopyOption[0]);
        }
    }
}

