/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.player;

import java.util.HashMap;
import java.util.UUID;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.accessor.Accessor;
import me.andre111.mambience.config.EngineConfig;
import me.andre111.mambience.scan.BlockScanner;

public class MAPlayer {
    private UUID playerUUID;
    private Accessor accessor;
    private BlockScanner scanner;
    private MALogger logger;
    private HashMap<String, Integer> cooldowns;

    public MAPlayer(UUID playerUUID, Accessor accessor, MALogger logger) {
        this.playerUUID = playerUUID;
        this.accessor = accessor;
        this.scanner = new BlockScanner(accessor, EngineConfig.SIZEX, EngineConfig.SIZEY, EngineConfig.SIZEZ);
        this.logger = logger;
        this.cooldowns = new HashMap();
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public BlockScanner getScanner() {
        return this.scanner;
    }

    public MALogger getLogger() {
        return this.logger;
    }

    public int getCooldown(String key) {
        if (!this.cooldowns.containsKey(key)) {
            return 0;
        }
        return this.cooldowns.get(key);
    }

    public void setCooldown(String key, int value) {
        if (value < 0) {
            value = 0;
        }
        this.cooldowns.put(key, value);
    }

    public int updateCooldown(String key) {
        if (!this.cooldowns.containsKey(key)) {
            return 0;
        }
        int value = this.cooldowns.get(key) - 1;
        this.cooldowns.put(key, value);
        return value;
    }
}

