/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.config.SoundscapeConfig;
import me.andre111.mambience.script.MAScripting;
import me.andre111.mambience.script.Variables;

public class EngineConfig {
    public static int SIZEX = 32;
    public static int SIZEY = 16;
    public static int SIZEZ = 32;
    public static float GLOBALVOLUME = 0.75f;
    public static boolean STOPSOUNDS = false;
    public static boolean DEBUGLOGGING = false;
    private static boolean initialized = false;

    public static void initialize(MALogger logger, File configRoot) {
        if (initialized) {
            return;
        }
        initialized = true;
        EngineConfig.exportSettings(configRoot);
        JsonParser parser = new JsonParser();
        File engine = new File(configRoot, "/settings/engine.json");
        try {
            JsonObject engineElement = parser.parse((Reader)new FileReader(engine)).getAsJsonObject();
            EngineConfig.loadSettings(engineElement.get("Settings").getAsJsonObject());
            EngineConfig.loadVariables(engineElement.get("Variables").getAsJsonArray());
            EngineConfig.loadMacros(engineElement.get("Macros").getAsJsonArray());
            EngineConfig.loadSoundscapes(logger, configRoot, engineElement.get("Soundscapes").getAsJsonArray());
        }
        catch (JsonIOException | JsonSyntaxException | FileNotFoundException e) {
            logger.error("Exception reading engine config: " + e);
        }
    }

    private static void exportSettings(File folder) {
        if (!folder.exists()) {
            folder.mkdir();
        }
        EngineConfig.exportSingleFile(folder, "/settings/engine.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/xshared.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/cave.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/desert.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/end.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/forest.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/hell.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/jungle.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/lava.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/mountain.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/plains.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/rain.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/savanna.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/seaside.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/snow.json");
        EngineConfig.exportSingleFile(folder, "/settings/soundscapes/swamp.json");
    }

    private static void exportSingleFile(File folder, String path) {
        File file = new File(folder, path);
        if (!file.exists()) {
            try {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
                Files.copy(EngineConfig.class.getResourceAsStream(path), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void loadSettings(JsonObject element) {
        SIZEX = element.get("ScannnerX").getAsInt();
        SIZEY = element.get("ScannnerY").getAsInt();
        SIZEZ = element.get("ScannnerZ").getAsInt();
        if (element.has("GlobalVolume")) {
            GLOBALVOLUME = element.get("GlobalVolume").getAsFloat();
        }
        STOPSOUNDS = element.get("StopSounds").getAsBoolean();
        if (element.has("DebugLogging")) {
            DEBUGLOGGING = element.get("DebugLogging").getAsBoolean();
        }
    }

    private static void loadSoundscapes(MALogger logger, File configRoot, JsonArray array) {
        for (int i = 0; i < array.size(); ++i) {
            String name = array.get(i).getAsString();
            SoundscapeConfig.loadSoundscape(logger, new File(configRoot, "/settings/" + name));
        }
    }

    private static void loadVariables(JsonArray array) {
        block8: for (int i = 0; i < array.size(); ++i) {
            String type;
            JsonObject variable = array.get(i).getAsJsonObject();
            String name = variable.get("Name").getAsString();
            switch (type = variable.get("Type").getAsString()) {
                case "BlockCount": {
                    int j;
                    JsonArray matArray = variable.get("Materials").getAsJsonArray();
                    String[] blocks = new String[matArray.size()];
                    for (j = 0; j < matArray.size(); ++j) {
                        blocks[j] = matArray.get(j).getAsString();
                    }
                    Variables.addBlockCountVariable(name, blocks);
                    continue block8;
                }
                case "BiomeCount": {
                    int j;
                    JsonArray biomeArray = variable.get("Biomes").getAsJsonArray();
                    String[] biomes = new String[biomeArray.size()];
                    for (j = 0; j < biomeArray.size(); ++j) {
                        biomes[j] = biomeArray.get(j).getAsString();
                    }
                    Variables.addBiomeCountVariable(name, biomes);
                    continue block8;
                }
            }
        }
    }

    private static void loadMacros(JsonArray array) {
        for (int i = 0; i < array.size(); ++i) {
            JsonObject macro = array.get(i).getAsJsonObject();
            String name = macro.get("Name").getAsString();
            String code = macro.get("Code").getAsString();
            MAScripting.addMacro(name, code);
        }
    }
}

