/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.accessor;

import java.util.Optional;
import java.util.UUID;
import me.andre111.mambience.accessor.Accessor;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.property.block.GroundLuminanceProperty;
import org.spongepowered.api.data.property.block.SkyLuminanceProperty;
import org.spongepowered.api.effect.sound.SoundCategories;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.weather.Weathers;

public class AccessorSponge
extends Accessor {
    private Player player;

    public AccessorSponge(UUID playerUUID) {
        super(playerUUID);
    }

    @Override
    public boolean updatePlayerInstance() {
        Optional optPlayer = Sponge.getServer().getPlayer(this.playerUUID);
        this.player = optPlayer.isPresent() ? (Player)optPlayer.get() : null;
        return this.player != null;
    }

    @Override
    public int getX() {
        return this.player.getLocation().getBlockX();
    }

    @Override
    public int getY() {
        return this.player.getLocation().getBlockY();
    }

    @Override
    public int getZ() {
        return this.player.getLocation().getBlockZ();
    }

    @Override
    public double getHealth() {
        return (Double)this.player.health().get();
    }

    @Override
    public double getFoodLevel() {
        return ((Integer)this.player.foodLevel().get()).intValue();
    }

    @Override
    public boolean isSubmerged() {
        BlockState headBlock = this.player.getLocation().add(0.0, 1.62, 0.0).getBlock();
        return headBlock.getType() == BlockTypes.WATER || headBlock.getType() == BlockTypes.FLOWING_WATER;
    }

    @Override
    public void playSound(String sound, float volume, float pitch) {
        this.player.playSound(SoundType.builder().build(sound), SoundCategories.AMBIENT, this.player.getLocation().getPosition(), (double)volume, (double)pitch);
    }

    @Override
    public void stopSound(String sound) {
        this.player.stopSounds(SoundType.builder().build(sound), SoundCategories.AMBIENT);
    }

    @Override
    public long getDayTime() {
        return this.player.getWorld().getProperties().getWorldTime() % 24000L;
    }

    @Override
    public long getFullTime() {
        return this.player.getWorld().getProperties().getTotalTime();
    }

    @Override
    public boolean isRaining() {
        return this.player.getWorld().getWeather().equals(Weathers.RAIN) || this.player.getWorld().getWeather().equals(Weathers.THUNDER_STORM);
    }

    @Override
    public String getBlock(int x, int y, int z) {
        BlockState block = this.player.getWorld().getBlock(x, y, z);
        String id = block.getType().getId();
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return id;
    }

    @Override
    public String getBiome(int x, int y, int z) {
        BiomeType biome = this.player.getWorld().getBiome(x, y, z);
        String id = biome.getId();
        if (!id.contains(":")) {
            id = "minecraft:" + id;
        }
        return id;
    }

    @Override
    public int getLight(int x, int y, int z) {
        Location loc = this.player.getWorld().getLocation(x, y, z);
        Optional sl = loc.getProperty(GroundLuminanceProperty.class);
        if (sl.isPresent()) {
            return ((Double)((GroundLuminanceProperty)sl.get()).getValue()).intValue();
        }
        return 0;
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        Location loc = this.player.getWorld().getLocation(x, y, z);
        Optional sl = loc.getProperty(GroundLuminanceProperty.class);
        if (sl.isPresent()) {
            return ((Double)((GroundLuminanceProperty)sl.get()).getValue()).intValue();
        }
        return 0;
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        Location loc = this.player.getWorld().getLocation(x, y, z);
        Optional sl = loc.getProperty(SkyLuminanceProperty.class);
        if (sl.isPresent()) {
            return ((Double)((SkyLuminanceProperty)sl.get()).getValue()).intValue();
        }
        return 0;
    }

    @Override
    public double getTemperature(int x, int y, int z) {
        return this.player.getWorld().getBiome(x, y, z).getTemperature();
    }

    @Override
    public double getHumidity(int x, int y, int z) {
        return this.player.getWorld().getBiome(x, y, z).getHumidity();
    }
}

