/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import me.andre111.mambience.MALogger;
import me.andre111.mambience.accessor.Accessor;
import me.andre111.mambience.player.MAPlayer;
import me.andre111.mambience.scan.BlockScanner;
import me.andre111.mambience.script.Variables;
import me.andre111.mambience.sound.Soundscapes;

public class MAScheduler
implements Runnable {
    private MALogger logger;
    private int intervall;
    private long timer;
    private Set<MAPlayer> players = new HashSet<MAPlayer>();
    private Queue<BlockScanner> scannerQueue = new LinkedList<BlockScanner>();
    private boolean clearPlayers = false;
    private List<MAPlayer> newPlayers = new ArrayList<MAPlayer>();

    public MAScheduler(MALogger l, int i) {
        this.logger = l;
        this.intervall = i;
        this.timer = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlayer(UUID player, Accessor accessor, MALogger logger) {
        MAPlayer maplayer = new MAPlayer(player, accessor, logger);
        Soundscapes.init(maplayer);
        List<MAPlayer> list = this.newPlayers;
        synchronized (list) {
            this.newPlayers.add(maplayer);
        }
    }

    public void clearPlayers() {
        this.clearPlayers = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime;
        long scapeTime = startTime = System.currentTimeMillis();
        ++this.timer;
        if (this.clearPlayers) {
            this.players.clear();
            this.clearPlayers = false;
        }
        List<MAPlayer> list = this.newPlayers;
        synchronized (list) {
            this.players.addAll(this.newPlayers);
            this.newPlayers.clear();
        }
        Iterator<MAPlayer> iterator = this.players.iterator();
        while (iterator.hasNext()) {
            MAPlayer maplayer = iterator.next();
            if (!maplayer.getAccessor().updatePlayerInstance()) {
                iterator.remove();
                continue;
            }
            Variables.update(maplayer);
            Soundscapes.update(maplayer);
            if (maplayer.getScanner().getLastScan() + (long)this.intervall > this.timer || this.scannerQueue.contains(maplayer.getScanner())) continue;
            this.scannerQueue.add(maplayer.getScanner());
        }
        scapeTime = System.currentTimeMillis();
        int refreshed = 0;
        int perTick = (int)Math.max(1.0, Math.ceil((double)this.players.size() / (double)this.intervall * 20.0));
        for (int i = 0; i < perTick; ++i) {
            BlockScanner scanner = this.scannerQueue.poll();
            if (scanner == null) continue;
            scanner.performScan();
            scanner.setLastScan(this.timer);
            ++refreshed;
        }
        long endTime = System.currentTimeMillis();
        this.logger.log("Refreshing " + refreshed + " Player(s) took " + (endTime - startTime) + "ms!");
        this.logger.log("\tVar+Scape: " + (scapeTime - startTime) + "ms     Scanner: " + (endTime - scapeTime) + "ms!");
    }
}

