/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.itemwrapper;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.util.IDataUpdate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class IntEnergyWrapper
implements ICapabilityProvider,
IEnergyStorage,
IDataUpdate {
    @Nonnull
    private final ItemStack stack;

    public IntEnergyWrapper(@Nonnull ItemStack stack) {
        this.stack = stack;
        CompoundNBT tagCompound = this.stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new CompoundNBT();
            this.stack.func_77982_d(tagCompound);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        return this.getCapability(cap);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == null) {
            return LazyOptional.empty();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return LazyOptional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveEnergy(int maxReceive, boolean simulate) {
        EnergyStorage storage = this.getStorage();
        try {
            int n = storage.receiveEnergy(maxReceive, simulate);
            return n;
        }
        finally {
            this.setStorage(storage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int extractEnergy(int maxExtract, boolean simulate) {
        EnergyStorage storage = this.getStorage();
        try {
            int n = storage.extractEnergy(maxExtract, simulate);
            return n;
        }
        finally {
            this.setStorage(storage);
        }
    }

    public int getEnergyStored() {
        return this.getStorage().getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.getStorage().getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.getStorage().canExtract();
    }

    public boolean canReceive() {
        return this.getStorage().canReceive();
    }

    @Nonnull
    private EnergyStorage getStorage() {
        if (this.stack.func_77978_p() == null) {
            Overloaded.logger.error((CharSequence)"Something has changed private internal state in an invalid way. Resetting State.", (Throwable)new IllegalStateException("private internal state changed. Stack's Tag Compound is null"));
            this.stack.func_77982_d(new CompoundNBT());
        }
        int energy = this.stack.func_77978_p().func_74762_e("IntEnergyStorage");
        return new EnergyStorage(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, energy);
    }

    private void setStorage(@Nonnull EnergyStorage storage) {
        this.stack.func_77978_p().func_74768_a("IntEnergyStorage", storage.getEnergyStored());
    }

    @Override
    public void dataUpdated() {
    }
}

