/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.capabilities.CapabilityGenericDataStorage;
import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.functional.PowerModItem;
import com.cjm721.overloaded.network.packets.RailGunFireMessage;
import com.cjm721.overloaded.network.packets.RailGunSettingsMessage;
import com.cjm721.overloaded.proxy.ClientProxy;
import com.cjm721.overloaded.storage.IGenericDataStorage;
import com.cjm721.overloaded.storage.itemwrapper.GenericDataCapabilityProviderWrapper;
import com.google.common.primitives.Ints;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ItemRailGun
extends PowerModItem {
    @Nonnull
    private static final String RAILGUN_POWER_KEY = "railgun.power";

    public ItemRailGun() {
        this.setRegistryName("railgun");
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        stack.getCapability(CapabilityGenericDataStorage.GENERIC_DATA_STORAGE).ifPresent(cap -> {
            cap.suggestUpdate();
            int energyRequirement = cap.getIntegerMap().getOrDefault(RAILGUN_POWER_KEY, OverloadedConfig.INSTANCE.railGun.minEnergy);
            tooltip.add((ITextComponent)new StringTextComponent(String.format("Power Usage: %s", NumberFormat.getInstance().format(energyRequirement))));
        });
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "railgun"), null);
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/item/railgun.png"), OverloadedConfig.INSTANCE.textureResolutions.itemResolution);
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        if (worldIn.field_72995_K) {
            int distance = OverloadedConfig.INSTANCE.railGun.maxRange;
            Vec3d vec3d = playerIn.func_174824_e(Minecraft.func_71410_x().func_184121_ak());
            Vec3d vec3d1 = playerIn.func_70676_i(Minecraft.func_71410_x().func_184121_ak());
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)distance, vec3d1.field_72448_b * (double)distance, vec3d1.field_72449_c * (double)distance);
            float f = 1.0f;
            AxisAlignedBB axisalignedbb = playerIn.func_174813_aQ().func_216361_a(vec3d1.func_186678_a((double)distance)).func_72314_b(1.0, 1.0, 1.0);
            EntityRayTraceResult ray = ProjectileHelper.func_221273_a((Entity)playerIn, (Vec3d)vec3d, (Vec3d)vec3d2, (AxisAlignedBB)axisalignedbb, p_215312_0_ -> !p_215312_0_.func_175149_v() && p_215312_0_.func_70067_L(), (double)(distance * distance));
            if (ray != null) {
                Vec3d moveVev = playerIn.func_174824_e(1.0f).func_178788_d(ray.func_216347_e()).func_72432_b().func_186678_a(-1.0);
                Overloaded.proxy.networkWrapper.sendToServer((Object)new RailGunFireMessage(ray.func_216348_a().func_145782_y(), moveVev, handIn));
            } else {
                Overloaded.proxy.networkWrapper.sendToServer((Object)new RailGunFireMessage(0, Vec3d.field_186680_a, handIn));
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (event.getScrollDelta() != 0.0 && player != null && player.func_226296_dJ_()) {
            ItemStack stack = player.func_184614_ca();
            if (player.func_226296_dJ_() && !stack.func_190926_b() && stack.func_77973_b() == this) {
                int powerDelta = Long.signum(Math.round(event.getScrollDelta())) * OverloadedConfig.INSTANCE.railGun.stepEnergy;
                if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)((ClientProxy)Overloaded.proxy).railGun100x.getKey().func_197937_c())) {
                    powerDelta *= 100;
                }
                Overloaded.proxy.networkWrapper.sendToServer((Object)new RailGunSettingsMessage(powerDelta));
                event.setCanceled(true);
            }
        }
    }

    public void handleFireMessage(@Nonnull ServerPlayerEntity player, @Nonnull RailGunFireMessage message) {
        ItemStack itemStack = player.func_184586_b(message.hand);
        if (itemStack.func_77973_b() != this) {
            return;
        }
        LazyOptional opEnergy = itemStack.getCapability(CapabilityEnergy.ENERGY);
        if (!opEnergy.isPresent()) {
            Overloaded.logger.warn("RailGun has no Energy Capability? NBT: " + itemStack.func_77978_p());
            return;
        }
        IEnergyStorage energy = (IEnergyStorage)opEnergy.orElseThrow(() -> new RuntimeException("Impossible Condition"));
        LazyOptional opSettingCapability = itemStack.getCapability(CapabilityGenericDataStorage.GENERIC_DATA_STORAGE);
        if (!opSettingCapability.isPresent()) {
            Overloaded.logger.warn("RailGun has no GenericData Capability? NBT: " + itemStack.func_77978_p());
            return;
        }
        IGenericDataStorage settingCapability = (IGenericDataStorage)opSettingCapability.orElseThrow(() -> new RuntimeException("Impossible Condition"));
        settingCapability.suggestUpdate();
        int energyRequired = settingCapability.getIntegerMap().getOrDefault(RAILGUN_POWER_KEY, OverloadedConfig.INSTANCE.railGun.minEnergy);
        if (energy.getEnergyStored() < energyRequired) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Not enough power to fire."), true);
            return;
        }
        int energyExtracted = energy.extractEnergy(energyRequired, false);
        Entity entity = player.field_70170_p.func_73045_a(message.id);
        if (entity == null || !entity.func_70089_S()) {
            return;
        }
        if (player.func_70032_d(entity) > (float)OverloadedConfig.INSTANCE.rayGun.maxRange) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Target out of range."), true);
        } else if (entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), (float)(OverloadedConfig.INSTANCE.railGun.damagePerRF * (double)energyExtracted))) {
            Vec3d knockback = message.moveVector.func_186678_a((double)energyExtracted * OverloadedConfig.INSTANCE.railGun.knockbackPerRF);
            entity.func_70024_g(knockback.field_72450_a, knockback.field_72448_b, knockback.field_72449_c);
        }
    }

    @Override
    public Collection<ICapabilityProvider> collectCapabilities(@Nonnull Collection<ICapabilityProvider> collection, ItemStack stack, @Nullable CompoundNBT nbt) {
        collection.add(new GenericDataCapabilityProviderWrapper(stack));
        return super.collectCapabilities(collection, stack, nbt);
    }

    public void handleSettingsMessage(@Nonnull ServerPlayerEntity player, @Nonnull RailGunSettingsMessage message) {
        ItemStack itemStack = player.func_184586_b(Hand.MAIN_HAND);
        if (itemStack.func_77973_b() != this) {
            return;
        }
        LazyOptional opCap = itemStack.getCapability(CapabilityGenericDataStorage.GENERIC_DATA_STORAGE);
        if (!opCap.isPresent()) {
            Overloaded.logger.warn("RailGun has no GenericData Capability? NBT: " + itemStack.func_77978_p());
            return;
        }
        IGenericDataStorage cap = (IGenericDataStorage)opCap.orElseThrow(() -> new RuntimeException("Impossible Condition"));
        Map<String, Integer> integerMap = cap.getIntegerMap();
        int power = integerMap.getOrDefault(RAILGUN_POWER_KEY, 0) + message.powerDelta;
        power = Ints.constrainToRange((int)power, (int)OverloadedConfig.INSTANCE.railGun.minEnergy, (int)OverloadedConfig.INSTANCE.railGun.maxEnergy);
        integerMap.put(RAILGUN_POWER_KEY, power);
        cap.suggestSave();
        player.func_146105_b((ITextComponent)new StringTextComponent("Power usage set to: " + NumberFormat.getInstance().format(power)), true);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="forge", bus=Mod.EventBusSubscriber.Bus.FORGE)
    private static class ClientSideEvents {
        private ClientSideEvents() {
        }
    }
}

