/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.render.item;

import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.ModItems;
import com.cjm721.overloaded.util.AssistMode;
import com.cjm721.overloaded.util.BlockItemUseContextPublic;
import com.cjm721.overloaded.util.PlayerInteractionUtil;
import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL14;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="overloaded", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RenderMultiToolAssist {
    @SubscribeEvent
    public static void onMouseEvent(InputEvent.MouseScrollEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (event.getScrollDelta() != 0.0 && player != null && player.func_226296_dJ_()) {
            ItemStack stack = player.func_184614_ca();
            if (player.func_226296_dJ_() && !stack.func_190926_b() && stack.func_77973_b() == ModItems.multiTool) {
                RenderMultiToolAssist.changeHelpMode((int)Math.round(event.getScrollDelta()));
                player.func_146105_b((ITextComponent)new StringTextComponent("Assist Mode: " + RenderMultiToolAssist.getAssistMode().getName()), true);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onKeyEvent(InputEvent.KeyInputEvent event) {
    }

    private static void changeHelpMode(int dwheel) {
        AssistMode[] values = AssistMode.values();
        int mode = (OverloadedConfig.INSTANCE.multiToolConfig.assistMode + Integer.signum(dwheel)) % values.length;
        if (mode < 0) {
            mode += values.length;
        }
        OverloadedConfig.INSTANCE.multiToolConfig.assistMode = mode;
    }

    @Nonnull
    public static AssistMode getAssistMode() {
        AssistMode[] values = AssistMode.values();
        int mode = OverloadedConfig.INSTANCE.multiToolConfig.assistMode;
        for (AssistMode assistMode : values) {
            if (assistMode.getMode() != mode) continue;
            return assistMode;
        }
        RenderMultiToolAssist.changeHelpMode(0);
        return AssistMode.NONE;
    }

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderWorldLastEvent event) {
        BlockState state;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184614_ca().func_77973_b() != ModItems.multiTool) {
            return;
        }
        BlockRayTraceResult result = PlayerInteractionUtil.getBlockPlayerLookingAtClient((PlayerEntity)player, event.getPartialTicks());
        if (result.func_216346_c() == RayTraceResult.Type.MISS) {
            return;
        }
        ItemStack stack = ModItems.multiTool.getSelectedBlockItemStack(player.func_184614_ca());
        if (stack.func_77973_b() instanceof BlockItem) {
            state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
            state = state.getStateAtViewpoint((IBlockReader)player.func_130014_f_(), result.func_216350_a(), player.func_174824_e(event.getPartialTicks()));
            state = state.func_177230_c().func_196258_a((BlockItemUseContext)new BlockItemUseContextPublic(player.func_130014_f_(), (PlayerEntity)player, Hand.MAIN_HAND, stack, result));
        } else {
            state = Blocks.field_150347_e.func_176223_P();
        }
        switch (RenderMultiToolAssist.getAssistMode()) {
            case PLACE_PREVIEW: {
                if (stack.func_190926_b() || state == null) break;
                RenderMultiToolAssist.renderBlockPreview(result, state);
                break;
            }
            case REMOVE_PREVIEW: {
                RenderMultiToolAssist.renderRemovePreview(result);
            }
            case BOTH_PREVIEW: {
                if (stack.func_190926_b() || state == null) break;
                RenderMultiToolAssist.renderBlockPreview(result, state);
            }
        }
    }

    private static void renderRemovePreview(BlockRayTraceResult result) {
        IBakedModel bakeModel = Minecraft.func_71410_x().func_209506_al().func_174953_a(new ModelResourceLocation("overloaded:remove_preview", ""));
        BlockPos toRenderAt = result.func_216350_a();
        RenderMultiToolAssist.renderBlockModel(toRenderAt, bakeModel, Blocks.field_150347_e.func_176223_P());
    }

    private static void renderBlockPreview(BlockRayTraceResult result, @Nonnull BlockState state) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        BlockPos toRenderAt = result.func_216350_a().func_177971_a(result.func_216354_b().func_176730_m());
        RenderMultiToolAssist.renderBlockModel(toRenderAt, model, state);
    }

    private static void renderBlockModel(BlockPos toRenderAt, @Nonnull IBakedModel model, @Nonnull BlockState state) {
        ActiveRenderInfo camera = Minecraft.func_71410_x().func_175598_ae().field_217783_c;
        if (camera == null) {
            return;
        }
        double x = camera.func_216785_c().func_82615_a();
        double y = camera.func_216785_c().func_82617_b();
        double z = camera.func_216785_c().func_82616_c();
        GlStateManager.func_227626_N_();
        GlStateManager.func_227670_b_((double)((double)toRenderAt.func_177958_n() - x), (double)((double)toRenderAt.func_177956_o() - y), (double)((double)toRenderAt.func_177952_p() - z));
        GlStateManager.func_227689_c_((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_227740_m_();
        GlStateManager.func_227676_b_((int)GlStateManager.SourceFactor.SRC_COLOR.ordinal(), (int)GlStateManager.DestFactor.CONSTANT_COLOR.ordinal());
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        GlStateManager.func_227626_N_();
        GlStateManager.func_227627_O_();
        GlStateManager.func_227737_l_();
        GlStateManager.func_227627_O_();
    }
}

