/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.basic;

import com.cjm721.overloaded.block.ModBlockTile;
import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.tile.functional.TilePlayerInterface;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.UsernameCache;

public class BlockPlayerInterface
extends ModBlockTile {
    public BlockPlayerInterface() {
        super(BlockPlayerInterface.getDefaultProperties());
        this.setRegistryName("player_interface");
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TilePlayerInterface();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        ((TilePlayerInterface)world.func_175625_s(pos)).setPlacer(entity);
        super.func_180633_a(world, pos, state, entity, stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModel() {
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/block/player_interface.png"), OverloadedConfig.INSTANCE.textureResolutions.blockResolution);
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (!world.field_72995_K && hand == Hand.MAIN_HAND) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TilePlayerInterface) {
                UUID placer = ((TilePlayerInterface)te).getPlacer();
                if (placer == null) {
                    player.func_145747_a((ITextComponent)new StringTextComponent("Not bound to anyone..... ghosts placed this."));
                } else {
                    String username = UsernameCache.getLastKnownUsername((UUID)placer);
                    player.func_145747_a((ITextComponent)new StringTextComponent("Bound to player: " + (username == null ? placer.toString() : username)));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, rayTraceResult);
    }
}

