/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.basic;

import com.cjm721.overloaded.block.ModBlock;
import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.tile.functional.TileItemInterface;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockItemInterface
extends ModBlock {
    public BlockItemInterface() {
        super(BlockItemInterface.getDefaultProperties());
        this.setRegistryName("item_interface");
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerModel() {
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/block/item_interface.png"), OverloadedConfig.INSTANCE.textureResolutions.blockResolution);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileItemInterface();
    }

    public void func_176208_a(World world, @Nonnull BlockPos pos, BlockState state, PlayerEntity player) {
        ((TileItemInterface)world.func_175625_s(pos)).breakBlock();
        super.func_176208_a(world, pos, state, player);
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.PASS;
        }
        if (hand != Hand.MAIN_HAND) {
            return ActionResultType.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileItemInterface)) {
            return ActionResultType.PASS;
        }
        TileItemInterface anInterface = (TileItemInterface)te;
        ItemStack stack = anInterface.getStoredItem();
        if (stack.func_190926_b()) {
            ItemStack handStack = player.func_184586_b(hand);
            if (handStack.func_190926_b()) {
                return ActionResultType.FAIL;
            }
            ItemStack returnedItem = anInterface.insertItem(0, handStack, false);
            player.func_184611_a(hand, returnedItem);
        } else {
            if (!player.func_184586_b(hand).func_190926_b()) {
                return ActionResultType.FAIL;
            }
            ItemStack toSpawn = anInterface.extractItem(0, 1, false);
            if (toSpawn.func_190926_b()) {
                return ActionResultType.FAIL;
            }
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)toSpawn, (int)player.field_71071_by.field_70461_c);
        }
        return ActionResultType.CONSUME;
    }
}

