/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.OverloadedCreativeTabs;
import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.item.functional.PowerModItem;
import com.cjm721.overloaded.network.packets.RayGunMessage;
import com.cjm721.overloaded.util.WorldUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRayGun
extends PowerModItem {
    public ItemRayGun() {
        this.setRegistryName("ray_gun");
        this.func_77655_b("ray_gun");
        this.func_77637_a(OverloadedCreativeTabs.TECH);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("\u00c2\u00a7oThe Little Zapper");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "ray_gun"), null);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)location);
        ImageUtil.registerDynamicTexture(new ResourceLocation("overloaded", "textures/items/ray_gun.png"), Overloaded.cachedConfig.textureResolutions.itemResolution);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand handIn) {
        RayTraceResult ray;
        if (!worldIn.field_72995_K) {
            new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        if ((ray = WorldUtil.rayTraceWithEntities(worldIn, playerIn.func_174824_e(Minecraft.func_71410_x().func_184121_ak()), playerIn.func_70676_i(Minecraft.func_71410_x().func_184121_ak()), (Entity)playerIn, 128.0)) != null) {
            RayGunMessage message = new RayGunMessage(ray.field_72307_f);
            Overloaded.proxy.networkWrapper.sendToServer((IMessage)message);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public void handleMessage(EntityPlayerMP player, RayGunMessage message) {
        ItemStack itemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (itemStack.func_77973_b() != this) {
            return;
        }
        IEnergyStorage energy = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
        if (energy.getEnergyStored() < Overloaded.cachedConfig.rayGun.energyPerShot) {
            player.func_146105_b((ITextComponent)new TextComponentString("Not enough power to fire."), true);
            return;
        }
        Vec3d eyePos = player.func_174824_e(1.0f);
        if (eyePos.func_72438_d(message.vector) > (double)Overloaded.cachedConfig.rayGun.maxRange) {
            player.func_146105_b((ITextComponent)new TextComponentString("Target out of range."), true);
            return;
        }
        RayTraceResult sanityCheckVec = player.field_70170_p.func_147447_a(eyePos, message.vector, false, false, false);
        if (sanityCheckVec != null && sanityCheckVec.field_72313_a != RayTraceResult.Type.MISS) {
            player.func_146105_b((ITextComponent)new TextComponentString("Target no longer in sight."), true);
            return;
        }
        energy.extractEnergy(Overloaded.cachedConfig.rayGun.energyPerShot, false);
        player.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(player.field_70170_p, message.vector.field_72450_a, message.vector.field_72448_b, message.vector.field_72449_c, false));
    }
}

