/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.utils.PairList;

public class AmbientEnviroment {
    public World world;
    public boolean soundsDisabled = false;
    public boolean night;
    public boolean raining;
    public boolean thundering;
    public PairList<BiomeArea, Float> biomes;
    public BlockEnviroment blocks = new BlockEnviroment();
    public PlayerEntity player;
    public double underwater;
    public double averageHeight;
    public double relativeHeight;
    public int minHeight;
    public int maxHeight;
    public double biomeVolume = 1.0;
    public AmbientDimension dimension;

    public AmbientEnviroment(PlayerEntity player) {
        this.player = player;
        this.world = player.field_70170_p;
    }

    public void updateWorld() {
        this.raining = this.world.func_175727_C(this.player.func_180425_c());
        this.thundering = this.world.func_72911_I();
    }

    public void setSunAngle(float sunAngle) {
        this.night = !(sunAngle > 0.75f) && !(sunAngle < 0.25f);
    }

    public void setUnderwater(double underwater) {
        this.underwater = underwater;
        if (underwater > 0.0) {
            this.blocks.outsideVolume = 0.0;
        }
    }

    public void setHeight(TerrainHeight terrain) {
        this.averageHeight = terrain.averageHeight;
        this.relativeHeight = this.player.func_226280_cw_() - terrain.averageHeight;
        this.minHeight = terrain.minHeight;
        this.maxHeight = terrain.maxHeight;
    }

    public static class BiomeArea {
        public final Biome biome;
        public final BlockPos pos;

        public BiomeArea(Biome biome, BlockPos pos) {
            this.biome = biome;
            this.pos = pos;
        }

        public boolean checkBiome(String[] names) {
            for (String name : names) {
                String biomename = this.biome.func_210773_k().toLowerCase().replace("_", " ");
                if (!biomename.matches(".*" + name.replace("*", ".*") + ".*")) continue;
                return true;
            }
            return false;
        }

        public boolean checkTopBlock(List<Block> topBlocks) {
            return topBlocks.contains(this.biome.func_203944_q().func_204108_a().func_177230_c());
        }

        public boolean equals(Object object) {
            if (object instanceof BiomeArea) {
                return ((BiomeArea)object).biome == this.biome;
            }
            return false;
        }

        public int hashCode() {
            return this.biome.hashCode();
        }
    }

    public static class BlockSpot {
        public BlockState state;
        public int distance;
        public int light;

        public BlockSpot(BlockState state, int distance, int light) {
            this.state = state;
            this.distance = distance;
            this.light = light;
        }

        public Material getMaterial() {
            return this.state.func_185904_a();
        }
    }

    public class BlockEnviroment {
        public double averageLight;
        public double outsideVolume;
        protected BlockSpot[] spots = new BlockSpot[Direction.values().length];

        public void updateAllDirections(AmbientEngine engine) {
            int lightspots = 0;
            this.averageLight = 0.0;
            BlockPos.Mutable pos = new BlockPos.Mutable();
            for (Direction facing : Direction.values()) {
                BlockSpot spot = this.updateDirection(pos, facing, engine);
                if (spot != null) {
                    this.spots[facing.ordinal()] = spot;
                    this.averageLight += (double)spot.light;
                    ++lightspots;
                    continue;
                }
                this.spots[facing.ordinal()] = null;
            }
            this.averageLight = lightspots == 0 ? (double)AmbientEnviroment.this.world.func_201696_r((BlockPos)pos.func_189535_a((Entity)AmbientEnviroment.this.player)) : (this.averageLight /= (double)lightspots);
            this.outsideVolume = this.calculateOutsideVolume(engine);
        }

        protected BlockSpot updateDirection(BlockPos.Mutable pos, Direction facing, AmbientEngine engine) {
            pos.func_189535_a((Entity)AmbientEnviroment.this.player);
            pos.func_185336_p(pos.func_177956_o() + 1);
            for (int i = 1; i < engine.blockScanDistance; ++i) {
                pos.func_181079_c(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o() + facing.func_96559_d(), pos.func_177952_p() + facing.func_82599_e());
                BlockState state = AmbientEnviroment.this.world.func_180495_p((BlockPos)pos);
                if (!state.func_200015_d((IBlockReader)AmbientEnviroment.this.world, (BlockPos)pos)) continue;
                return new BlockSpot(state, i, AmbientEnviroment.this.world.func_201696_r(pos.func_177972_a(facing.func_176734_d())));
            }
            return null;
        }

        protected double calculateOutsideVolume(AmbientEngine engine) {
            Integer distanceX = this.spots[Direction.EAST.ordinal()] == null ? null : (this.spots[Direction.WEST.ordinal()] == null ? null : Integer.valueOf(this.spots[Direction.EAST.ordinal()].distance + this.spots[Direction.WEST.ordinal()].distance));
            Integer distanceY = this.spots[Direction.UP.ordinal()] == null ? null : (this.spots[Direction.DOWN.ordinal()] == null ? null : Integer.valueOf(this.spots[Direction.UP.ordinal()].distance + this.spots[Direction.DOWN.ordinal()].distance));
            Integer distanceZ = this.spots[Direction.SOUTH.ordinal()] == null ? null : (this.spots[Direction.NORTH.ordinal()] == null ? null : Integer.valueOf(this.spots[Direction.SOUTH.ordinal()].distance + this.spots[Direction.NORTH.ordinal()].distance));
            double volumeVertical = distanceY == null ? 1.0 : MathHelper.func_151237_a((double)((double)(distanceY - engine.outsideDistanceMin) / (double)(engine.outsideDistanceMax - engine.outsideDistanceMin)), (double)0.0, (double)1.0);
            double volumeHorizontal = distanceX == null || distanceZ == null ? 1.0 : MathHelper.func_151237_a((double)((double)(Math.max(distanceX, distanceZ) - engine.outsideDistanceMin) / (double)(engine.outsideDistanceMax - engine.outsideDistanceMin)), (double)0.0, (double)1.0);
            return volumeHorizontal * volumeVertical;
        }
    }

    public static class TerrainHeight {
        public final double averageHeight;
        public final int minHeight;
        public final int maxHeight;

        public TerrainHeight(double averageHeight, int minHeight, int maxHeight) {
            this.averageHeight = averageHeight;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }
    }
}

