/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.legacy.blue_skies.world.util.JigsawRegistryHelper;
import com.legacy.blue_skies.world.util.SkiesJigsawPiece;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.template.StructureProcessor;

public class JigsawPoolBuilder {
    private Map<ResourceLocation, Integer> names = ImmutableMap.of();
    private List<StructureProcessor> processors = ImmutableList.of();
    private boolean maintainWater = true;

    private JigsawPoolBuilder(Map<ResourceLocation, Integer> names) {
        this.names = names;
    }

    public static JigsawPoolBuilder names(Map<String, Integer> nameMap) {
        HashMap<ResourceLocation, Integer> tempNames = new HashMap<ResourceLocation, Integer>();
        nameMap.forEach((s, i) -> tempNames.put(JigsawRegistryHelper.locatePiece(s), (Integer)i));
        return new JigsawPoolBuilder(tempNames);
    }

    public static JigsawPoolBuilder names(String ... nameArray) {
        HashMap<ResourceLocation, Integer> tempNames = new HashMap<ResourceLocation, Integer>();
        for (String s : nameArray) {
            tempNames.put(JigsawRegistryHelper.locatePiece(s), 1);
        }
        return new JigsawPoolBuilder(tempNames);
    }

    public JigsawPoolBuilder processors(StructureProcessor ... processors) {
        this.processors = (List)Arrays.asList(processors).stream().collect(ImmutableList.toImmutableList());
        return this;
    }

    public JigsawPoolBuilder maintainWater(boolean maintainWater) {
        this.maintainWater = maintainWater;
        return this;
    }

    public List<Pair<JigsawPiece, Integer>> build() {
        ArrayList jigsawList = new ArrayList();
        this.names.forEach((rl, i) -> jigsawList.add(Pair.of((Object)((Object)new SkiesJigsawPiece((ResourceLocation)rl, this.processors).setMaintainWater(this.maintainWater)), (Object)i)));
        return (List)jigsawList.stream().collect(ImmutableList.toImmutableList());
    }

    public static List<Pair<JigsawPiece, Integer>> build(Map<JigsawPiece, Integer> pieceMap) {
        ArrayList jigsawList = new ArrayList();
        pieceMap.forEach((jp, i) -> jigsawList.add(Pair.of((Object)jp, (Object)i)));
        return (List)jigsawList.stream().collect(ImmutableList.toImmutableList());
    }

    public static List<Pair<JigsawPiece, Integer>> build(JigsawPiece ... pieces) {
        ArrayList<Pair<JigsawPiece, Integer>> pairs = new ArrayList<Pair<JigsawPiece, Integer>>();
        for (JigsawPiece p : pieces) {
            pairs.add((Pair<JigsawPiece, Integer>)Pair.of((Object)p, (Object)1));
        }
        return pairs;
    }

    @SafeVarargs
    public static <P extends Pair<JigsawPiece, Integer>> List<P> collect(List<P> ... lists) {
        List pairs = new ArrayList();
        for (List<P> l : lists) {
            pairs = (List)Streams.concat((Stream[])new Stream[]{pairs.stream(), l.stream()}).collect(ImmutableList.toImmutableList());
        }
        return pairs;
    }
}

