/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.structures;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesStructurePieceTypes;
import com.legacy.blue_skies.world.general_features.structures.GatekeeperHouseConfig;
import com.legacy.blue_skies.world.util.JigsawPoolBuilder;
import com.legacy.blue_skies.world.util.JigsawRegistryHelper;
import com.legacy.blue_skies.world.util.RemoveSnowStructureProcessor;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.common.Tags;

public class GatekeeperHousePieces {
    private static final RuleStructureProcessor portalRule = new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(SkiesBlocks.lunar_stonebrick), (RuleTest)AlwaysTrueRuleTest.field_215190_a, SkiesBlocks.turquoise_stonebrick.func_176223_P())));

    public static void init(ChunkGenerator<?> chunkGen, TemplateManager template, BlockPos pos, List<StructurePiece> pieces, SharedSeedRandom seed, GatekeeperHouseConfig config) {
        JigsawRegistryHelper.setPrefix("gatekeeper/");
        JigsawRegistryHelper.register("gatekeeper", JigsawPoolBuilder.names("gatekeeper").build());
        JigsawRegistryHelper.register("pig", JigsawPoolBuilder.names("pig").build());
        GatekeeperHousePieces.registerSnowy();
        GatekeeperHousePieces.registerPlains();
        GatekeeperHousePieces.registerMountains();
        JigsawManager.func_214889_a((ResourceLocation)config.startPool, (int)4, Piece::new, chunkGen, (TemplateManager)template, (BlockPos)pos, pieces, (Random)seed);
    }

    private static void registerSnowy() {
        JigsawRegistryHelper.setPrefix("gatekeeper/snowy/");
        JigsawRegistryHelper.register("main", JigsawPoolBuilder.collect(JigsawPoolBuilder.names("main").processors(new StructureProcessor[]{portalRule, RemoveSnowStructureProcessor.INSTANCE}).build(), JigsawPoolBuilder.names("main").processors(RemoveSnowStructureProcessor.INSTANCE).build()));
        JigsawRegistryHelper.register("bedroom", JigsawPoolBuilder.names("bedroom_1", "bedroom_2").processors(RemoveSnowStructureProcessor.INSTANCE).build());
        JigsawRegistryHelper.register("storage", JigsawPoolBuilder.names("storage_1", "storage_2").processors(RemoveSnowStructureProcessor.INSTANCE).build());
    }

    private static void registerPlains() {
        JigsawRegistryHelper.setPrefix("gatekeeper/plains/");
        RuleStructureProcessor pathRule = new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_185774_da), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_196662_n.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(Blocks.field_185774_da, 0.2f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, Blocks.field_196658_i.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_150355_j.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150346_d), (RuleTest)new BlockMatchRuleTest(Blocks.field_150355_j), Blocks.field_196662_n.func_176223_P())));
        JigsawRegistryHelper.register("main", JigsawPoolBuilder.collect(JigsawPoolBuilder.names("main_1", "main_2").build(), JigsawPoolBuilder.names("main_1", "main_2").processors(new StructureProcessor[]{portalRule}).build()));
        JigsawRegistryHelper.register("path", JigsawPoolBuilder.names("path_1", "path_2").processors(new StructureProcessor[]{pathRule}).build(), JigsawPattern.PlacementBehaviour.TERRAIN_MATCHING);
        JigsawRegistryHelper.register("shack", JigsawPoolBuilder.names("shack_1", "shack_2").build());
    }

    private static void registerMountains() {
        JigsawRegistryHelper.setPrefix("gatekeeper/mountain/");
        RuleStructureProcessor grassRule = new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), (RuleTest)new TagMatchRuleTest(Tags.Blocks.STONE), Blocks.field_150348_b.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), (RuleTest)new BlockMatchRuleTest(Blocks.field_150351_n), Blocks.field_150348_b.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), (RuleTest)new BlockMatchRuleTest(Blocks.field_150350_a), Blocks.field_150348_b.func_176223_P())));
        RuleStructureProcessor undersideRule = new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150348_b), (RuleTest)new BlockMatchRuleTest(Blocks.field_196658_i), Blocks.field_196658_i.func_176223_P()), (Object)new RuleEntry((RuleTest)new BlockMatchRuleTest(Blocks.field_150348_b), (RuleTest)new BlockMatchRuleTest(Blocks.field_150346_d), Blocks.field_150346_d.func_176223_P())));
        JigsawRegistryHelper.register("main", JigsawPoolBuilder.collect(JigsawPoolBuilder.names("main").processors(new StructureProcessor[]{portalRule, grassRule}).build(), JigsawPoolBuilder.names("main").processors(new StructureProcessor[]{grassRule}).build()));
        JigsawRegistryHelper.register("side", JigsawPoolBuilder.names("side_1", "side_2").processors(new StructureProcessor[]{grassRule}).build());
        JigsawRegistryHelper.register("back", JigsawPoolBuilder.names("back_1", "back_2").processors(new StructureProcessor[]{grassRule}).build());
        JigsawRegistryHelper.register("underside", JigsawPoolBuilder.names("underside").processors(new StructureProcessor[]{undersideRule}).build());
    }

    public static class Piece
    extends AbstractVillagePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super(SkiesStructurePieceTypes.GATEKEEPER_HOUSE, template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt, SkiesStructurePieceTypes.GATEKEEPER_HOUSE);
        }
    }
}

