/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class CherryTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = SkiesBlocks.cherry_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.cherry_leaves.func_176223_P();

    public CherryTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean doBlockNofityOnPlace) {
        super(config, doBlockNofityOnPlace);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int i = rand.nextInt(3) + 10;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (CherryTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (CherryTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling())) {
                this.setLeafBall(changedBlocks, worldIn, position.func_177982_a(0, i - 2, 0), boundingBox);
                for (int y = 0; y < i; ++y) {
                    this.setBlock(changedBlocks, worldIn, position.func_177981_b(y), LOG, boundingBox);
                }
                this.setBranches(changedBlocks, worldIn, rand, position, boundingBox, i);
                this.setSideLogs(changedBlocks, worldIn, position, boundingBox);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void setBranches(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox, int height) {
        int i;
        int iPosX = height - 4 - rand.nextInt(3);
        int iNegX = height - 4 - rand.nextInt(3);
        int iPosZ = height - 4 - rand.nextInt(3);
        int iNegZ = height - 4 - rand.nextInt(3);
        for (i = 1; i <= 3; ++i) {
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, iPosX + i, 0), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X), boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, iPosZ + i, i), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Z), boundingBox);
            if (i != 3) continue;
            this.setLeafBall(changedBlocks, worldIn, position.func_177982_a(i, iPosX + 2, rand.nextInt(3) - 1), boundingBox);
            this.setLeafBall(changedBlocks, worldIn, position.func_177982_a(rand.nextInt(3) - 1, iPosZ + 2, i), boundingBox);
        }
        for (i = -1; i >= -3; --i) {
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, iNegX - i, 0), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X), boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, iNegZ - i, i), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Z), boundingBox);
            if (i != -3) continue;
            this.setLeafBall(changedBlocks, worldIn, position.func_177982_a(i, iNegX + 2, rand.nextInt(3) - 1), boundingBox);
            this.setLeafBall(changedBlocks, worldIn, position.func_177982_a(rand.nextInt(3) - 1, iNegZ + 2, i), boundingBox);
        }
    }

    protected void setLeafBall(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, MutableBoundingBox boundingBox) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = 0; k <= 2; ++k) {
                    if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, k, j), LEAF, boundingBox);
                }
            }
        }
        this.setLeafCap(changedBlocks, worldIn, position.func_177977_b(), boundingBox);
        this.setLeafCap(changedBlocks, worldIn, position.func_177981_b(3), boundingBox);
    }

    protected void setLeafCap(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, MutableBoundingBox boundingBox) {
        this.setBlock(changedBlocks, worldIn, position, LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177964_d(1), LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177970_e(1), LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177965_g(1), LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177985_f(1), LEAF, boundingBox);
    }

    protected void setSideLogs(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, MutableBoundingBox boundingBox) {
        BlockPos blockpos = new BlockPos(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        for (int i = 0; i >= -1; --i) {
            this.setBlock(changedBlocks, worldIn, blockpos.func_177982_a(1, i, 0), LOG, boundingBox);
            this.setBlock(changedBlocks, worldIn, blockpos.func_177982_a(-1, i, 0), LOG, boundingBox);
            this.setBlock(changedBlocks, worldIn, blockpos.func_177982_a(0, i, 1), LOG, boundingBox);
            this.setBlock(changedBlocks, worldIn, blockpos.func_177982_a(0, i, -1), LOG, boundingBox);
        }
    }

    protected void setBlock(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, BlockState state, MutableBoundingBox boundingBox) {
        if (CherryTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position)) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position, state, boundingBox);
        }
    }
}

