/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesStructurePieceTypes;
import com.legacy.blue_skies.tile_entity.KeystoneTileEntity;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class EverdawnBlindingDungeonPieces {
    private static final ResourceLocation base = EverdawnBlindingDungeonPieces.locatePiece("base");
    private static final ResourceLocation segment = EverdawnBlindingDungeonPieces.locatePiece("segment");
    private static final ResourceLocation segmentTop = EverdawnBlindingDungeonPieces.locatePiece("segment_top");
    private static final ResourceLocation towerTop = EverdawnBlindingDungeonPieces.locatePiece("tower_top");
    private static final ResourceLocation bridge = EverdawnBlindingDungeonPieces.locatePiece("bridge");
    private static final ResourceLocation libraryTower = EverdawnBlindingDungeonPieces.locatePiece("small_tower_library");
    private static final ResourceLocation prisonTower = EverdawnBlindingDungeonPieces.locatePiece("small_tower_prison");
    private static final ResourceLocation studyTower = EverdawnBlindingDungeonPieces.locatePiece("small_tower_study");
    private static final ResourceLocation witchTower = EverdawnBlindingDungeonPieces.locatePiece("small_tower_witch");

    public static void init(TemplateManager templateManager, BlockPos pos, Rotation rotation, List<StructurePiece> structurePieces, Random random) {
        int i;
        structurePieces.add((StructurePiece)new Piece(templateManager, base, pos, rotation));
        for (i = 1; i <= 4; ++i) {
            structurePieces.add((StructurePiece)new Piece(templateManager, segment, pos.func_177981_b(8 * i), rotation));
        }
        structurePieces.add((StructurePiece)new Piece(templateManager, segmentTop, pos.func_177981_b(40), rotation));
        structurePieces.add((StructurePiece)new Piece(templateManager, towerTop, pos.func_177982_a(-6, 48, -6), rotation));
        i = random.nextInt(3) + 2;
        structurePieces.add((StructurePiece)new Piece(templateManager, bridge, pos.func_177982_a(6, i * 9 - 2 - i, -5), Rotation.COUNTERCLOCKWISE_90));
        structurePieces.add((StructurePiece)new Piece(templateManager, prisonTower, pos.func_177982_a(2, i * 9 - 5 - i, -19), Rotation.COUNTERCLOCKWISE_90));
        i = random.nextInt(3) + 2;
        structurePieces.add((StructurePiece)new Piece(templateManager, bridge, pos.func_177982_a(-6, i * 9 - 2 - i, 7), Rotation.CLOCKWISE_180));
        structurePieces.add((StructurePiece)new Piece(templateManager, studyTower, pos.func_177982_a(-19, i * 9 - 5 - i, 2), Rotation.CLOCKWISE_180));
        i = random.nextInt(3) + 2;
        structurePieces.add((StructurePiece)new Piece(templateManager, bridge, pos.func_177982_a(6, i * 9 - 2 - i, 19), Rotation.CLOCKWISE_90));
        structurePieces.add((StructurePiece)new Piece(templateManager, witchTower, pos.func_177982_a(2, i * 9 - 5 - i, 23), Rotation.CLOCKWISE_90));
        i = random.nextInt(3) + 2;
        structurePieces.add((StructurePiece)new Piece(templateManager, bridge, pos.func_177982_a(18, i * 9 - 2 - i, 7), Rotation.NONE));
        structurePieces.add((StructurePiece)new Piece(templateManager, libraryTower, pos.func_177982_a(23, i * 9 - 5 - i, 2), Rotation.NONE));
    }

    static ResourceLocation locatePiece(String location) {
        return BlueSkies.locate("dungeons/everdawn/blinding/" + location);
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final ResourceLocation location;
        private final Rotation rotation;

        public Piece(TemplateManager templateManager, ResourceLocation location, BlockPos pos, Rotation rotation) {
            super(SkiesStructurePieceTypes.EVERDAWN_BLINDING_DUNGEON, 0);
            this.location = location;
            this.field_186178_c = pos;
            this.rotation = rotation;
            this.setupTemplate(templateManager);
        }

        public Piece(TemplateManager templateManager, CompoundNBT nbtCompound) {
            super(SkiesStructurePieceTypes.EVERDAWN_BLINDING_DUNGEON, nbtCompound);
            this.location = new ResourceLocation(nbtCompound.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)nbtCompound.func_74779_i("Rot"));
            this.setupTemplate(templateManager);
        }

        private void setupTemplate(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.location);
            BlockPos sizePos = templateManager.func_200219_b(this.location).func_186259_a();
            BlockPos centerPos = new BlockPos(sizePos.func_177958_n() / 2, 0, sizePos.func_177952_p() / 2);
            PlacementSettings placementSettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a(centerPos).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
            placementSettings.func_215222_a((StructureProcessor)new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(SkiesBlocks.blinding_stone, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, SkiesBlocks.glowing_blinding_stone.func_176223_P()))));
            this.func_186173_a(template, this.field_186178_c, placementSettings);
        }

        protected void func_143011_b(CompoundNBT tagCompound) {
            super.func_143011_b(tagCompound);
            tagCompound.func_74778_a("Template", this.location.toString());
            tagCompound.func_74778_a("Rot", this.rotation.name());
        }

        public boolean func_74875_a(IWorld worldIn, Random randomIn, MutableBoundingBox bounds, ChunkPos chunkPosIn) {
            boolean flag = super.func_74875_a(worldIn, randomIn, bounds, chunkPosIn);
            if (this.location == base) {
                for (int x = 0; x < this.field_186176_a.func_186259_a().func_177958_n(); ++x) {
                    for (int z = 0; z < this.field_186176_a.func_186259_a().func_177952_p(); ++z) {
                        if (this.func_175807_a((IBlockReader)worldIn, x, 0, z, bounds).func_185904_a() == Material.field_151579_a) continue;
                        if (this.func_175807_a((IBlockReader)worldIn, x, 0, z, bounds).func_177230_c() == SkiesBlocks.lunar_log) {
                            this.func_175808_b(worldIn, SkiesBlocks.lunar_log.func_176223_P(), x, -1, z, bounds);
                            continue;
                        }
                        this.func_175808_b(worldIn, SkiesBlocks.lunar_stonebrick.func_176223_P(), x, -1, z, bounds);
                    }
                }
            }
            return flag;
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld worldIn, Random rand, MutableBoundingBox sbb) {
            if ("keystone".equals(function)) {
                worldIn.func_180501_a(pos, SkiesBlocks.dawn_blinding_keystone.func_176223_P(), 3);
                TileEntity tileEntity = worldIn.func_175625_s(pos);
                if (tileEntity instanceof KeystoneTileEntity.DawnBlindingKeystoneTileEntity) {
                    ((KeystoneTileEntity.DawnBlindingKeystoneTileEntity)tileEntity).setTeleportOffset(new BlockPos(3, 7, 3));
                    ((KeystoneTileEntity.DawnBlindingKeystoneTileEntity)tileEntity).setSpawnOffset(new BlockPos(0, 7, 0));
                }
            } else if ("villager".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                VillagerEntity entity = (VillagerEntity)EntityType.field_200756_av.func_200721_a(worldIn.func_201672_e());
                entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                worldIn.func_217376_c((Entity)entity);
            } else if ("vindicator".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                VindicatorEntity entity = (VindicatorEntity)EntityType.field_200758_ax.func_200721_a(worldIn.func_201672_e());
                entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                entity.func_110163_bv();
                ItemStack axe = new ItemStack((IItemProvider)SkiesItems.turquoise_axe, 1);
                axe.func_196082_o().func_74778_a("Stick", SkiesItems.bluebright_stick.getRegistryName().toString());
                entity.func_184201_a(EquipmentSlotType.MAINHAND, axe);
                worldIn.func_217376_c((Entity)entity);
            } else if ("witch".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                WitchEntity entity = (WitchEntity)EntityType.field_200759_ay.func_200721_a(worldIn.func_201672_e());
                entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                entity.func_110163_bv();
                worldIn.func_217376_c((Entity)entity);
            } else if ("cat".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                CatEntity entity = (CatEntity)EntityType.field_220360_g.func_200721_a(worldIn.func_201672_e());
                entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                entity.func_110163_bv();
                entity.func_70903_f(true);
                entity.func_213422_r(rand.nextInt(10));
                entity.func_213417_a(DyeColor.values()[rand.nextInt(DyeColor.values().length)]);
                entity.func_184754_b(UUID.fromString("8ab9311e-6b8d-4633-80d5-e1798b1c6a96"));
                entity.func_70904_g(true);
                worldIn.func_217376_c((Entity)entity);
            } else if ("armor_stand".equals(function)) {
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                ArmorStandEntity entity = (ArmorStandEntity)EntityType.field_200789_c.func_200721_a(worldIn.func_201672_e());
                entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                entity.func_200602_a(EntityAnchorArgument.Type.EYES, new Vec3d(0.0, 0.0, 0.0));
                entity.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)SkiesItems.pyrope_chestplate));
                worldIn.func_217376_c((Entity)entity);
            }
        }
    }
}

