/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.layer;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.world.everdawn.gen.EverdawnGenSettings;
import com.legacy.blue_skies.world.everdawn.gen.layer.DawnRiverLayer;
import com.legacy.blue_skies.world.everdawn.gen.layer.EverdawnBiomeLayer;
import com.legacy.blue_skies.world.everdawn.gen.layer.MixDawnRiverLayer;
import java.util.function.LongFunction;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.layer.AddIslandLayer;
import net.minecraft.world.gen.layer.AddSnowLayer;
import net.minecraft.world.gen.layer.EdgeLayer;
import net.minecraft.world.gen.layer.HillsLayer;
import net.minecraft.world.gen.layer.IslandLayer;
import net.minecraft.world.gen.layer.Layer;
import net.minecraft.world.gen.layer.RareBiomeLayer;
import net.minecraft.world.gen.layer.SmoothLayer;
import net.minecraft.world.gen.layer.StartRiverLayer;
import net.minecraft.world.gen.layer.VoroniZoomLayer;
import net.minecraft.world.gen.layer.ZoomLayer;
import net.minecraft.world.gen.layer.traits.IAreaTransformer1;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.eventbus.api.Event;

public class EverdawnLayer {
    protected static final int WARM_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203614_T);
    protected static final int LUKEWARM_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203615_U);
    protected static final int OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76771_b);
    protected static final int COLD_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203616_V);
    protected static final int FROZEN_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_76776_l);
    protected static final int DEEP_WARM_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203617_W);
    protected static final int DEEP_LUKEWARM_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203618_X);
    protected static final int DEEP_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_150575_M);
    protected static final int DEEP_COLD_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203619_Y);
    protected static final int DEEP_FROZEN_OCEAN = Registry.field_212624_m.func_148757_b((Object)Biomes.field_203620_Z);

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> IAreaFactory<T> repeat(long seed, IAreaTransformer1 parent, IAreaFactory<T> p_202829_3_, int count, LongFunction<C> contextFactory) {
        IAreaFactory iareafactory = p_202829_3_;
        for (int i = 0; i < count; ++i) {
            iareafactory = parent.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(seed + (long)i), iareafactory);
        }
        return iareafactory;
    }

    public static <T extends IArea, C extends IExtendedNoiseRandom<T>> ImmutableList<IAreaFactory<T>> buildEverdawnProcedure(WorldType worldTypeIn, EverdawnGenSettings settings, LongFunction<C> contextFactory) {
        int i;
        IAreaFactory<T> iareafactory = IslandLayer.INSTANCE.func_202823_a((IExtendedNoiseRandom)contextFactory.apply(1L));
        iareafactory = ZoomLayer.FUZZY.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2000L), (IAreaFactory)iareafactory);
        iareafactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1L), (IAreaFactory)iareafactory);
        iareafactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2001L), (IAreaFactory)iareafactory);
        iareafactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(50L), (IAreaFactory)iareafactory);
        iareafactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(70L), (IAreaFactory)iareafactory);
        iareafactory = AddSnowLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3L), (IAreaFactory)iareafactory);
        iareafactory = EdgeLayer.CoolWarm.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = EdgeLayer.HeatIce.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2L), (IAreaFactory)iareafactory);
        iareafactory = EdgeLayer.Special.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3L), (IAreaFactory)iareafactory);
        iareafactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2002L), (IAreaFactory)iareafactory);
        iareafactory = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(2003L), (IAreaFactory)iareafactory);
        iareafactory = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(4L), (IAreaFactory)iareafactory);
        iareafactory = EverdawnLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, iareafactory, 0, contextFactory);
        int j = i = 4;
        if (settings != null) {
            i = settings.getBiomeSize();
            j = settings.getRiverSize();
        }
        if (worldTypeIn == WorldType.field_77135_d) {
            i = 6;
        }
        i = EverdawnLayer.getModdedBiomeSize(worldTypeIn, i);
        IAreaFactory lvt_7_1_ = EverdawnLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, iareafactory, 0, contextFactory);
        lvt_7_1_ = StartRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(100L), lvt_7_1_);
        IAreaFactory lvt_8_1_ = new EverdawnBiomeLayer(worldTypeIn, settings).func_202713_a((IExtendedNoiseRandom)contextFactory.apply(200L), iareafactory);
        IAreaFactory<T> lvt_9_1_ = EverdawnLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, lvt_7_1_, 2, contextFactory);
        lvt_8_1_ = HillsLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(1000L), lvt_8_1_, lvt_9_1_);
        lvt_7_1_ = EverdawnLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, lvt_7_1_, 2, contextFactory);
        lvt_7_1_ = EverdawnLayer.repeat(1000L, (IAreaTransformer1)ZoomLayer.NORMAL, lvt_7_1_, j, contextFactory);
        lvt_7_1_ = DawnRiverLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1L), lvt_7_1_);
        lvt_7_1_ = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), lvt_7_1_);
        lvt_8_1_ = RareBiomeLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1001L), lvt_8_1_);
        for (int k = 0; k < i; ++k) {
            lvt_8_1_ = ZoomLayer.NORMAL.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000 + k), lvt_8_1_);
            if (k != 0) continue;
            lvt_8_1_ = AddIslandLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(3L), lvt_8_1_);
        }
        lvt_8_1_ = SmoothLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(1000L), lvt_8_1_);
        lvt_8_1_ = MixDawnRiverLayer.INSTANCE.func_202707_a((IExtendedNoiseRandom)contextFactory.apply(100L), lvt_8_1_, lvt_7_1_);
        IAreaFactory iareafactory5 = VoroniZoomLayer.INSTANCE.func_202713_a((IExtendedNoiseRandom)contextFactory.apply(10L), lvt_8_1_);
        return ImmutableList.of((Object)lvt_8_1_, (Object)iareafactory5, (Object)lvt_8_1_);
    }

    public static Layer[] buildEverdawnProcedure(long seed, WorldType typeIn, EverdawnGenSettings settings) {
        ImmutableList immutablelist = EverdawnLayer.buildEverdawnProcedure(typeIn, settings, (long p_215737_2_) -> new LazyAreaLayerContext(25, seed, p_215737_2_));
        Layer layer = new Layer((IAreaFactory)immutablelist.get(0));
        Layer layer1 = new Layer((IAreaFactory)immutablelist.get(1));
        Layer layer2 = new Layer((IAreaFactory)immutablelist.get(2));
        return new Layer[]{layer, layer1, layer2};
    }

    public static boolean areBiomesSimilar(int p_202826_0_, int p_202826_1_) {
        return p_202826_0_ == p_202826_1_;
    }

    public static int getModdedBiomeSize(WorldType worldType, int original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, original);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getNewSize();
    }

    protected static boolean isOcean(int biomeIn) {
        return biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN || biomeIn == DEEP_WARM_OCEAN || biomeIn == DEEP_LUKEWARM_OCEAN || biomeIn == DEEP_OCEAN || biomeIn == DEEP_COLD_OCEAN || biomeIn == DEEP_FROZEN_OCEAN;
    }

    protected static boolean isShallowOcean(int biomeIn) {
        return biomeIn == WARM_OCEAN || biomeIn == LUKEWARM_OCEAN || biomeIn == OCEAN || biomeIn == COLD_OCEAN || biomeIn == FROZEN_OCEAN;
    }
}

