/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.blocks.natural.NectarineLeavesBlock;
import com.legacy.blue_skies.blocks.natural.SkyLeavesBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class NectarineTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = SkiesBlocks.dusk_log.func_176223_P();
    private static final BlockState LEAF = (BlockState)SkiesBlocks.nectarine_leaves.func_176223_P().func_206870_a((IProperty)SkyLeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(false));
    private static final BlockState LEAF_MATURE = (BlockState)((BlockState)SkiesBlocks.nectarine_leaves.func_176223_P().func_206870_a((IProperty)SkyLeavesBlock.field_208495_b, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)NectarineLeavesBlock.MATURE, (Comparable)Boolean.valueOf(true));

    public NectarineTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean notify) {
        super(config, notify);
        this.setSapling((IPlantable)SkiesBlocks.nectarine_sapling);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int i = rand.nextInt(3) + 6;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= 256) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (NectarineTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (NectarineTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling())) {
                this.setLeaves(changedBlocks, worldIn, rand, position, boundingBox, i);
                for (int j2 = 0; j2 < i; ++j2) {
                    this.setBlock(changedBlocks, worldIn, position.func_177981_b(j2), LOG, boundingBox);
                }
                this.setSideLogs(changedBlocks, worldIn, rand, position, boundingBox);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void setLeaves(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox, int height) {
        int i;
        BlockPos blockpos = new BlockPos(position.func_177958_n(), position.func_177956_o() - 1 + height, position.func_177952_p());
        for (i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = -3; k <= -1; ++k) {
                    if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                    if (k == -3 && rand.nextInt(3) == 0) {
                        this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(i, k, j), boundingBox);
                    }
                    if (k < -2) continue;
                    this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(i, k, j), boundingBox);
                }
            }
        }
        for (i = 0; i <= 1; ++i) {
            if (i == 0) {
                this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(1, i, 1), boundingBox);
                this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(1, i, -1), boundingBox);
                this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(-1, i, 1), boundingBox);
                this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(-1, i, -1), boundingBox);
            }
            this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(1, i, 0), boundingBox);
            this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(0, i, 1), boundingBox);
            this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(0, i, 0), boundingBox);
            this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(0, i, -1), boundingBox);
            this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(-1, i, 0), boundingBox);
        }
        this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(2, 0, 0), boundingBox);
        this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(-2, 0, 0), boundingBox);
        this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(0, 0, 2), boundingBox);
        this.setLeaf(changedBlocks, worldIn, rand, blockpos.func_177982_a(0, 0, -2), boundingBox);
    }

    protected void setSideLogs(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        BlockPos blockpos = new BlockPos(position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        for (int i = 0; i >= -1; --i) {
            this.setBlock(changedBlocks, worldIn, blockpos.func_177982_a(1, i, 0), LOG, boundingBox);
            this.setBlock(changedBlocks, worldIn, blockpos.func_177982_a(-1, i, 0), LOG, boundingBox);
            this.setBlock(changedBlocks, worldIn, blockpos.func_177982_a(0, i, 1), LOG, boundingBox);
            this.setBlock(changedBlocks, worldIn, blockpos.func_177982_a(0, i, -1), LOG, boundingBox);
        }
        this.setBlock(changedBlocks, worldIn, blockpos.func_177982_a(rand.nextInt(3) - 1, 1, 0), LOG, boundingBox);
        this.setBlock(changedBlocks, worldIn, blockpos.func_177982_a(0, 1, rand.nextInt(3) - 1), LOG, boundingBox);
    }

    protected void setLeaf(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        this.setBlock(changedBlocks, worldIn, position, rand.nextDouble() > 0.33 ? LEAF : LEAF_MATURE, boundingBox);
    }

    protected void setBlock(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, BlockState state, MutableBoundingBox boundingBox) {
        if (NectarineTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position)) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position, state, boundingBox);
        }
    }
}

