/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class MapleTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = SkiesBlocks.maple_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.maple_leaves.func_176223_P();

    public MapleTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean doBlockNofityOnPlace) {
        super(config, doBlockNofityOnPlace);
        this.setSapling((IPlantable)SkiesBlocks.maple_sapling);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int h = rand.nextInt(4) + ((double)rand.nextFloat() < 0.2 ? 13 : 9);
        if (this.canPlaceTree(worldIn, position, h)) {
            int y;
            boolean branchType = rand.nextBoolean();
            for (y = 0; y <= h; ++y) {
                this.setBlock(changedBlocks, worldIn, position.func_177981_b(y), LOG, boundingBox);
            }
            if (branchType) {
                for (y = -2; y < 1; ++y) {
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            if (y < 0) {
                                this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, y + h, z), LEAF, boundingBox);
                                continue;
                            }
                            if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                            this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, y + h, z), LEAF, boundingBox);
                        }
                    }
                }
                this.setBlock(changedBlocks, worldIn, position.func_177981_b(h + 1), LEAF, boundingBox);
                this.setBlock(changedBlocks, worldIn, position.func_177981_b(h + 2), LEAF, boundingBox);
            } else {
                int z;
                int x;
                for (x = -2; x <= 2; ++x) {
                    for (z = -2; z <= 2; ++z) {
                        if (Math.abs(x) + Math.abs(z) >= 3) continue;
                        this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, h - 5, z), LEAF, boundingBox);
                        this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, h - 1, z), LEAF, boundingBox);
                        this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, h, z), LEAF, boundingBox);
                    }
                }
                for (x = -3; x <= 3; ++x) {
                    for (z = -3; z <= 3; ++z) {
                        if (Math.abs(x) + Math.abs(z) >= 4) continue;
                        this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, h - 4, z), LEAF, boundingBox);
                        this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, h - 2, z), LEAF, boundingBox);
                    }
                }
                for (x = -3; x <= 3; ++x) {
                    for (z = -3; z <= 3; ++z) {
                        if (Math.abs(x) + Math.abs(z) >= 4 && (Math.abs(x) != 2 || Math.abs(z) != 2)) continue;
                        this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, h - 3, z), LEAF, boundingBox);
                    }
                }
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        if (Math.abs(x) + Math.abs(z) >= 2) continue;
                        this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, h + 1, z), LEAF, boundingBox);
                    }
                }
            }
            if (branchType) {
                this.setLowerBranch(changedBlocks, worldIn, position.func_177982_a(0, h - rand.nextInt(3) - 3, -1), boundingBox, Direction.NORTH);
                this.setLowerBranch(changedBlocks, worldIn, position.func_177982_a(1, h - rand.nextInt(3) - 3, 0), boundingBox, Direction.EAST);
                this.setLowerBranch(changedBlocks, worldIn, position.func_177982_a(0, h - rand.nextInt(3) - 3, 1), boundingBox, Direction.SOUTH);
                this.setLowerBranch(changedBlocks, worldIn, position.func_177982_a(-1, h - rand.nextInt(3) - 3, 0), boundingBox, Direction.WEST);
            }
            return true;
        }
        return false;
    }

    protected void setLowerBranch(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, MutableBoundingBox boundingBox, Direction direction) {
        this.setBlock(changedBlocks, worldIn, position, (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)direction.func_176740_k()), boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177967_a(direction, 1), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)direction.func_176740_k()), boundingBox);
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                int x1 = Math.abs(x);
                int z1 = Math.abs(z);
                if (z1 == 1 && x1 == 1) continue;
                this.setBlock(changedBlocks, worldIn, position.func_177967_a(direction, 1).func_177982_a(x, 0, z), LEAF, boundingBox);
                this.setBlock(changedBlocks, worldIn, position.func_177967_a(direction, 1).func_177982_a(x, -1, z), LEAF, boundingBox);
            }
        }
        this.setBlock(changedBlocks, worldIn, position.func_177967_a(direction, 1).func_177984_a(), LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177967_a(direction, 1).func_177979_c(2), LEAF, boundingBox);
    }

    public boolean canPlaceTree(IWorldGenerationReader worldIn, BlockPos position, int height) {
        return MapleTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling());
    }

    protected void setBlock(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, BlockState state, MutableBoundingBox boundingBox) {
        if (MapleTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position)) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position, state, boundingBox);
        }
    }
}

