/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class LargeDuskTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = SkiesBlocks.dusk_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.dusk_leaves.func_176223_P();

    public LargeDuskTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean doBlockNofityOnPlace) {
        super(config, doBlockNofityOnPlace);
        this.setSapling((IPlantable)SkiesBlocks.dusk_sapling);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int h = rand.nextInt(5) + 16;
        if (this.canPlaceTree(worldIn, position, h)) {
            int z1;
            int x1;
            int z;
            int x;
            for (int y = 0; y < h; ++y) {
                for (int x2 = 0; x2 < 2; ++x2) {
                    for (int z2 = 0; z2 < 2; ++z2) {
                        this.setBlock(changedBlocks, worldIn, position.func_177982_a(x2, y, z2), LOG, boundingBox);
                    }
                }
            }
            for (x = -4; x <= 4; ++x) {
                for (z = -4; z <= 4; ++z) {
                    if (x == 0) {
                        x = 1;
                    }
                    if (z == 0) {
                        z = 1;
                    }
                    BlockPos pos = position.func_177982_a(x > 0 ? x - 1 : x, h - 2, z > 0 ? z - 1 : z).func_177982_a(1, 0, 1);
                    x1 = Math.abs(x);
                    z1 = Math.abs(z);
                    if (z1 >= 4 && z1 == 4 && x1 == 4) continue;
                    this.setBlock(changedBlocks, worldIn, pos, LEAF, boundingBox);
                    if (!((double)rand.nextFloat() < 0.3)) continue;
                    this.setBlock(changedBlocks, worldIn, pos.func_177977_b(), LEAF, boundingBox);
                }
            }
            for (x = -4; x <= 4; ++x) {
                for (z = -4; z <= 4; ++z) {
                    if (x == 0) {
                        x = 1;
                    }
                    if (z == 0) {
                        z = 1;
                    }
                    BlockPos pos = position.func_177982_a(x > 0 ? x - 1 : x, h - 1, z > 0 ? z - 1 : z).func_177982_a(1, 0, 1);
                    x1 = Math.abs(x);
                    z1 = Math.abs(z);
                    if (z1 + x1 >= 7) continue;
                    this.setBlock(changedBlocks, worldIn, pos, LEAF, boundingBox);
                }
            }
            for (x = -3; x <= 3; ++x) {
                for (z = -3; z <= 3; ++z) {
                    if (x == 0) {
                        x = 1;
                    }
                    if (z == 0) {
                        z = 1;
                    }
                    BlockPos pos = position.func_177982_a(x > 0 ? x - 1 : x, h, z > 0 ? z - 1 : z).func_177982_a(1, 0, 1);
                    x1 = Math.abs(x);
                    z1 = Math.abs(z);
                    if (z1 == 3 && x1 == 3) continue;
                    this.setBlock(changedBlocks, worldIn, pos, LEAF, boundingBox);
                }
            }
            this.setLowerBranch(changedBlocks, worldIn, position.func_177982_a(rand.nextInt(2), rand.nextInt(5) + 6, -1), boundingBox, Direction.NORTH);
            this.setLowerBranch(changedBlocks, worldIn, position.func_177982_a(2, rand.nextInt(5) + 6, rand.nextInt(2)), boundingBox, Direction.EAST);
            this.setLowerBranch(changedBlocks, worldIn, position.func_177982_a(rand.nextInt(2), rand.nextInt(5) + 6, 2), boundingBox, Direction.SOUTH);
            this.setLowerBranch(changedBlocks, worldIn, position.func_177982_a(-1, rand.nextInt(5) + 6, rand.nextInt(2)), boundingBox, Direction.WEST);
            for (x = -1; x <= 2; ++x) {
                for (z = -1; z <= 2; ++z) {
                    if (!rand.nextBoolean() || !((x == -1 || x == 2) ^ (z == -1 || z == 2))) continue;
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, 0, z), LOG, boundingBox);
                    if (!rand.nextBoolean()) continue;
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, 1, z), LOG, boundingBox);
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, 2, z), LOG, boundingBox);
                    if (!rand.nextBoolean()) continue;
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, 3, z), LOG, boundingBox);
                }
            }
            return true;
        }
        return false;
    }

    protected void setLowerBranch(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, MutableBoundingBox boundingBox, Direction direction) {
        this.setBlock(changedBlocks, worldIn, position, (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)direction.func_176740_k()), boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177967_a(direction, 1), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)direction.func_176740_k()), boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177967_a(direction, 2).func_177984_a(), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)direction.func_176740_k()), boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177967_a(direction, 3).func_177984_a(), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)direction.func_176740_k()), boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177967_a(direction, 4).func_177981_b(2), LOG, boundingBox);
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                int x1 = Math.abs(x);
                int z1 = Math.abs(z);
                this.setBlock(changedBlocks, worldIn, position.func_177967_a(direction, 4).func_177982_a(x, 2, z), LEAF, boundingBox);
                if (z1 != 2 || x1 != 2) {
                    this.setBlock(changedBlocks, worldIn, position.func_177967_a(direction, 4).func_177982_a(x, 3, z), LEAF, boundingBox);
                }
                if (!(Math.random() < 0.3)) continue;
                this.setBlock(changedBlocks, worldIn, position.func_177967_a(direction, 4).func_177982_a(x, 1, z), LEAF, boundingBox);
            }
        }
    }

    protected void setBlock(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, BlockState state, MutableBoundingBox boundingBox) {
        if (LargeDuskTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position)) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position, state, boundingBox);
        }
    }

    public boolean canPlaceTree(IWorldGenerationReader worldIn, BlockPos position, int height) {
        return LargeDuskTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling()) && LargeDuskTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(1, -1, 0), (IPlantable)this.getSapling()) && LargeDuskTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(1, -1, 1), (IPlantable)this.getSapling()) && LargeDuskTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(0, -1, 1), (IPlantable)this.getSapling());
    }
}

