/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class DuskTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = SkiesBlocks.dusk_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.dusk_leaves.func_176223_P();
    private int minTreeHeight;

    public DuskTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean notify, int minTreeHeightIn) {
        super(config, notify);
        this.minTreeHeight = minTreeHeightIn;
        this.setSapling((IPlantable)SkiesBlocks.dusk_sapling);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int i = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (DuskTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (DuskTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.sapling)) {
                this.setLeafCanopy(changedBlocks, worldIn, rand, position.func_177982_a(0, i - 2, 0), boundingBox);
                for (int j3 = 0; j3 < i; ++j3) {
                    if (!DuskTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(j3))) continue;
                    this.func_202278_a((IWorldWriter)worldIn, position.func_177981_b(j3), LOG);
                }
                this.setBranches(changedBlocks, worldIn, rand, position, boundingBox, i);
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    protected void setBranches(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox, int height) {
        int i = height - 3;
        if (rand.nextBoolean()) {
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(1, i, 0), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X), boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(-1, i, 0), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X), boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(2, i + 1, 0), LOG, boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(-2, i + 1, 0), LOG, boundingBox);
        } else {
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, i, 1), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Z), boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, i, -1), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Z), boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, i + 1, 2), LOG, boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, i + 1, -2), LOG, boundingBox);
        }
    }

    protected void setLeafCanopy(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int j;
        int i;
        for (i = -3; i <= 3; ++i) {
            for (j = -3; j <= 3; ++j) {
                if (Math.abs(i) == 3 && Math.abs(j) == 3 || rand.nextInt(3) != 0) continue;
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, 0, j), LEAF, boundingBox);
            }
        }
        position = position.func_177984_a();
        for (i = -3; i <= 3; ++i) {
            for (j = -3; j <= 3; ++j) {
                if (Math.abs(i) == 3 && Math.abs(j) == 3) continue;
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, 0, j), LEAF, boundingBox);
            }
        }
        for (i = -4; i <= 4; ++i) {
            for (j = -1; j <= 1; ++j) {
                if (Math.abs(i) != 4) continue;
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, 0, j), LEAF, boundingBox);
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(j, 0, i), LEAF, boundingBox);
            }
        }
        position = position.func_177984_a();
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, 0, j), LEAF, boundingBox);
            }
        }
    }

    protected void setBlock(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, BlockState state, MutableBoundingBox boundingBox) {
        if (DuskTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position)) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position, state, boundingBox);
        }
    }
}

