/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen;

import com.legacy.blue_skies.world.everdawn.gen.EverdawnGenSettings;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.OctavesNoiseGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.CatSpawner;
import net.minecraft.world.spawner.PatrolSpawner;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class EverdawnChunkGenerator
extends NoiseChunkGenerator<EverdawnGenSettings> {
    private static final float[] field_222576_h = (float[])Util.func_200696_a((Object)new float[25], p_222575_0_ -> {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                float f;
                p_222575_0_[i + 2 + (j + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
            }
        }
    });
    private final OctavesNoiseGenerator depthNoise;
    private final boolean isAmplified;
    private final PatrolSpawner patrolSpawner = new PatrolSpawner();
    private final CatSpawner catSpawner = new CatSpawner();

    public EverdawnChunkGenerator(IWorld worldIn, BiomeProvider provider, EverdawnGenSettings settingsIn) {
        super(worldIn, provider, 4, 8, 256, (GenerationSettings)settingsIn, true);
        this.field_222558_e.func_202423_a(2620);
        this.depthNoise = new OctavesNoiseGenerator((Random)this.field_222558_e, 16);
        this.isAmplified = worldIn.func_72912_H().func_76067_t() == WorldType.field_151360_e;
    }

    public void func_202093_c(WorldGenRegion region) {
        int i = region.func_201679_a();
        int j = region.func_201680_b();
        Biome biome = region.func_212866_a_(i, j).func_201590_e()[0];
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom();
        sharedseedrandom.func_202424_a(region.func_72905_C(), i << 4, j << 4);
        WorldEntitySpawner.func_77191_a((IWorld)region, (Biome)biome, (int)i, (int)j, (Random)sharedseedrandom);
    }

    protected void func_222548_a(double[] noiseColumn, int noiseX, int noiseZ) {
        this.func_222546_a(noiseColumn, noiseX, noiseZ, 684.412f, 684.412f, 8.555149841308594, 4.277574920654297, 3, -10);
    }

    protected double func_222545_a(double p_222545_1_, double p_222545_3_, int p_222545_5_) {
        double d1 = ((double)p_222545_5_ - (8.5 + p_222545_1_ * 8.5 / 8.0 * 4.0)) * 12.0 * 128.0 / 256.0 / p_222545_3_;
        if (d1 < 0.0) {
            d1 *= 4.0;
        }
        return d1;
    }

    protected double[] func_222549_a(int noiseX, int noiseZ) {
        double[] adouble = new double[2];
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        float f3 = this.field_222542_c.func_222366_b(noiseX, noiseZ).func_185355_j();
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                Biome biome = this.field_222542_c.func_222366_b(noiseX + j, noiseZ + k);
                float f4 = biome.func_185355_j();
                float f5 = biome.func_185360_m();
                if (this.isAmplified && f4 > 0.0f) {
                    f4 = 1.0f + f4 * 2.0f;
                    f5 = 1.0f + f5 * 4.0f;
                }
                float f6 = field_222576_h[j + 2 + (k + 2) * 5] / (f4 + 2.0f);
                if (biome.func_185355_j() > f3) {
                    f6 /= 2.0f;
                }
                f += f5 * f6;
                f1 += f4 * f6;
                f2 += f6;
            }
        }
        f /= f2;
        f1 /= f2;
        f = f * 0.9f + 0.1f;
        f1 = (f1 * 4.0f - 1.0f) / 8.0f;
        adouble[0] = (double)f1 + this.getNoiseDepthAt(noiseX, noiseZ);
        adouble[1] = f;
        return adouble;
    }

    private double getNoiseDepthAt(int p_222574_1_, int p_222574_2_) {
        double d0 = this.depthNoise.func_215462_a((double)(p_222574_1_ * 200), 10.0, (double)(p_222574_2_ * 200), 1.0, 0.0, true) / 8000.0;
        if (d0 < 0.0) {
            d0 = -d0 * 0.3;
        }
        if ((d0 = d0 * 3.0 - 2.0) < 0.0) {
            d0 /= 28.0;
        } else {
            if (d0 > 1.0) {
                d0 = 1.0;
            }
            d0 /= 40.0;
        }
        return d0;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EntityClassification creatureType, BlockPos pos) {
        return super.func_177458_a(creatureType, pos);
    }

    public void func_203222_a(ServerWorld worldIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        this.patrolSpawner.func_222696_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
        this.catSpawner.func_221124_a(worldIn, spawnHostileMobs, spawnPeacefulMobs);
    }

    public int func_205470_d() {
        return this.field_222540_a.func_181545_F() + 1;
    }

    public int func_222530_f() {
        return 63;
    }
}

