/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.dungeon;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesFeatures;
import com.legacy.blue_skies.world.everbright.gen.EverbrightGenSettings;
import com.legacy.blue_skies.world.everbright.gen.structures.dungeon.EverbrightDungeonConfig;
import com.legacy.blue_skies.world.everbright.gen.structures.dungeon.EverbrightDungeonPieces;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class EverbrightDungeonStructure
extends Structure<EverbrightDungeonConfig> {
    public EverbrightDungeonStructure(Function<Dynamic<?>, ? extends EverbrightDungeonConfig> config) {
        super(config);
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int posX, int posZ, int spacingOffsetsX, int spacingOffsetsZ) {
        int distance = EverbrightGenSettings.getDungeonDistance();
        int separation = EverbrightGenSettings.getDungeonSeparation();
        int x = posX + distance * spacingOffsetsX;
        int z = posZ + distance * spacingOffsetsZ;
        int x1 = x < 0 ? x - distance + 1 : x;
        int z1 = z < 0 ? z - distance + 1 : z;
        int x2 = x1 / distance;
        int z2 = z1 / distance;
        ((SharedSeedRandom)random).func_202427_a(chunkGenerator.func_202089_c(), x2, z2, 10387313);
        x2 *= distance;
        z2 *= distance;
        return new ChunkPos(x2 += (random.nextInt(distance - separation) + random.nextInt(distance - separation)) / 2, z2 += (random.nextInt(distance - separation) + random.nextInt(distance - separation)) / 2);
    }

    public boolean func_202372_a(ChunkGenerator<?> chunkGen, Random rand, int chunkPosX, int chunkPosZ) {
        ChunkPos chunkPos = this.func_211744_a(chunkGen, rand, chunkPosX, chunkPosZ, 0, 0);
        if (chunkPosX == chunkPos.field_77276_a && chunkPosZ == chunkPos.field_77275_b) {
            Biome biome = chunkGen.func_202090_b().func_222364_a(new BlockPos((chunkPosX << 4) + 9, 0, (chunkPosZ << 4) + 9));
            if (!chunkGen.func_202094_a(biome, SkiesFeatures.EVERBRIGHT_DUNGEON)) {
                return false;
            }
            int y = EverbrightDungeonStructure.getYValue(chunkGen, chunkPos.field_77276_a, chunkPos.field_77275_b);
            return y <= 80 && y >= 60;
        }
        return false;
    }

    public Structure.IStartFactory func_214557_a() {
        return Start::new;
    }

    public String func_143025_a() {
        return BlueSkies.find("everbright_dungeon");
    }

    public int func_202367_b() {
        return 0;
    }

    public static int getYValue(ChunkGenerator<?> chunkGen, int chunkX, int chunkZ) {
        return chunkGen.func_222531_c(chunkX << 4, chunkZ << 4, Heightmap.Type.WORLD_SURFACE_WG);
    }

    public static class Start
    extends StructureStart {
        public Start(Structure<?> structure, int chunkX, int chunkZ, Biome biome, MutableBoundingBox boundingBox, int referenceIn, long seed) {
            super(structure, chunkX, chunkZ, biome, boundingBox, referenceIn, seed);
        }

        public void func_214625_a(ChunkGenerator<?> chunkGen, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn) {
            int y = EverbrightDungeonStructure.getYValue(chunkGen, chunkX, chunkZ);
            if (y <= 80 && y >= 60) {
                BlockPos blockpos = new BlockPos(chunkX * 16 + 8, y, chunkZ * 16 + 8);
                EverbrightDungeonPieces.init(chunkGen, templateManagerIn, blockpos, this.field_75075_a, this.field_214631_d);
                this.func_202500_a();
            }
        }
    }
}

