/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.structures.dungeon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesStructurePieceTypes;
import com.legacy.blue_skies.world.util.JigsawPoolBuilder;
import com.legacy.blue_skies.world.util.JigsawRegistryHelper;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.AlwaysTrueRuleTest;
import net.minecraft.world.gen.feature.template.RandomBlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleEntry;
import net.minecraft.world.gen.feature.template.RuleStructureProcessor;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class EverbrightDungeonPieces {
    public static void init(ChunkGenerator<?> chunkGen, TemplateManager template, BlockPos pos, List<StructurePiece> pieces, SharedSeedRandom seed) {
        JigsawManager.func_214889_a((ResourceLocation)BlueSkies.locate("dungeons/everbright/dungeon/entrance"), (int)7, Piece::new, chunkGen, (TemplateManager)template, (BlockPos)pos, pieces, (Random)seed);
    }

    static ResourceLocation locatePiece(String location) {
        return BlueSkies.locate("dungeons/everbright/dungeon/" + location);
    }

    static {
        RuleStructureProcessor deteriorate = new RuleStructureProcessor((List)ImmutableList.of((Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(SkiesBlocks.turquoise_stonebrick, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, SkiesBlocks.mossy_turquoise_stonebrick.func_176223_P()), (Object)new RuleEntry((RuleTest)new RandomBlockMatchRuleTest(SkiesBlocks.turquoise_stonebrick, 0.1f), (RuleTest)AlwaysTrueRuleTest.field_215190_a, SkiesBlocks.cracked_turquoise_stonebrick.func_176223_P())));
        JigsawRegistryHelper.setPrefix("dungeons/everbright/dungeon/");
        JigsawRegistryHelper.register("entrance", JigsawPoolBuilder.names("entrance").processors(new StructureProcessor[]{deteriorate}).maintainWater(false).build());
        JigsawRegistryHelper.register("pipe", JigsawPoolBuilder.names("pipe").processors(new StructureProcessor[]{deteriorate}).maintainWater(false).build());
        JigsawRegistryHelper.register("main_room", JigsawPoolBuilder.names("main_room").processors(new StructureProcessor[]{deteriorate}).maintainWater(false).build());
        JigsawRegistryHelper.register("rooms", JigsawPoolBuilder.names("rooms/room_1", "rooms/room_2", "rooms/room_3", "rooms/room_4").processors(new StructureProcessor[]{deteriorate}).maintainWater(false).build());
        JigsawRegistryHelper.register("loot_chests", JigsawPoolBuilder.names((Map<String, Integer>)ImmutableMap.of((Object)"loot_chests/loot_chest_common", (Object)10, (Object)"loot_chests/loot_chest_rare", (Object)3)).maintainWater(false).build());
    }

    public static class Piece
    extends AbstractVillagePiece {
        public Piece(TemplateManager template, JigsawPiece jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox boundingBox) {
            super(SkiesStructurePieceTypes.EVERBRIGHT_DUNGEON, template, jigsawPiece, pos, groundLevelDelta, rotation, boundingBox);
        }

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(template, nbt, SkiesStructurePieceTypes.EVERBRIGHT_DUNGEON);
        }
    }
}

