/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class StarlitTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = SkiesBlocks.starlit_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.starlit_leaves.func_176223_P();

    public StarlitTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean notify) {
        super(config, notify);
        this.setSapling((IPlantable)SkiesBlocks.starlit_sapling);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int i = rand.nextInt(3) + 7;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= 256) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (AbstractTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (StarlitTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - i - 1) {
                int y;
                for (y = 0; y < i; ++y) {
                    this.setBlock(changedBlocks, worldIn, position.func_177981_b(y), LOG, boundingBox);
                }
                this.setBlock(changedBlocks, worldIn, position.func_177981_b(i), LEAF, boundingBox);
                this.setBlock(changedBlocks, worldIn, position.func_177981_b(i + 1), LEAF, boundingBox);
                this.setBlock(changedBlocks, worldIn, position.func_177981_b(i + 2), LEAF, boundingBox);
                for (y = i - 5; y <= i; ++y) {
                    int z;
                    int x;
                    this.setBlock(changedBlocks, worldIn, position.func_177972_a(Direction.NORTH).func_177981_b(y), LEAF, boundingBox);
                    this.setBlock(changedBlocks, worldIn, position.func_177972_a(Direction.SOUTH).func_177981_b(y), LEAF, boundingBox);
                    this.setBlock(changedBlocks, worldIn, position.func_177972_a(Direction.EAST).func_177981_b(y), LEAF, boundingBox);
                    this.setBlock(changedBlocks, worldIn, position.func_177972_a(Direction.WEST).func_177981_b(y), LEAF, boundingBox);
                    if (y == i - 4 || y == i - 2) {
                        x = -2;
                        z = 0;
                        while (x <= 0) {
                            this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, y, z), LEAF, boundingBox);
                            this.setBlock(changedBlocks, worldIn, position.func_177982_a(x + 1, y, z - 1), LEAF, boundingBox);
                            this.setBlock(changedBlocks, worldIn, position.func_177982_a(x + 2, y, z - 2), LEAF, boundingBox);
                            ++x;
                            ++z;
                        }
                    }
                    if (y != i - 3 && y != i - 1) continue;
                    x = 1;
                    z = 1;
                    for (int j = 0; j <= 1; ++j) {
                        for (int k = 0; k <= 1; ++k) {
                            if (rand.nextBoolean()) {
                                this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, y, z), LEAF, boundingBox);
                            }
                            z = Math.negateExact(z);
                        }
                        x = Math.negateExact(x);
                    }
                }
                return true;
            }
        } else {
            return false;
        }
        return false;
    }

    protected void setBlock(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, BlockState state, MutableBoundingBox boundingBox) {
        if (StarlitTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position)) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position, state, boundingBox);
        }
    }
}

