/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class SlushlandTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = SkiesBlocks.bluebright_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.bluebright_leaves.func_176223_P();

    public SlushlandTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean notify, boolean useExtraRandomHeightIn) {
        super(config, notify);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int h = 6 + rand.nextInt(2);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + h + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + h; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + h - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (SlushlandTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (SlushlandTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.sapling) || worldIn.func_217375_a(position.func_177977_b(), blockState -> FluidTags.field_206959_a.func_199685_a_((Object)blockState.func_204520_s().func_206886_c())) && (SlushlandTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177979_c(2), (IPlantable)this.sapling) || SlushlandTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177979_c(3), (IPlantable)this.sapling))) {
                if (position.func_177956_o() < worldIn.getMaxHeight() - h - 1) {
                    for (int l1 = 0; l1 < h + 2; ++l1) {
                        if (!SlushlandTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(l1))) continue;
                        if (l1 > h - 3) {
                            this.setBlock(changedBlocks, worldIn, position.func_177981_b(l1), LOG, boundingBox);
                            if (l1 == h - 1) {
                                this.setBlock(changedBlocks, worldIn, position.func_177982_a(1, l1, 0), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X), boundingBox);
                                this.setBlock(changedBlocks, worldIn, position.func_177982_a(-1, l1, 0), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X), boundingBox);
                                this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, l1, 1), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Z), boundingBox);
                                this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, l1, -1), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Z), boundingBox);
                            }
                        }
                        if (l1 != 1) continue;
                        this.setBaseLogs(changedBlocks, worldIn, rand, position, boundingBox);
                    }
                    this.setLeaves(changedBlocks, worldIn, rand, position.func_177981_b(h), boundingBox);
                    return true;
                }
                return false;
            }
        } else {
            return false;
        }
        return false;
    }

    protected void setLeaves(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int k;
        int j;
        int i;
        for (i = -4; i <= 4; ++i) {
            for (j = -2; j <= 2; ++j) {
                for (k = -1; k <= 0; ++k) {
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, k, j), LEAF, boundingBox);
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(j, k, i), LEAF, boundingBox);
                }
            }
        }
        for (int k2 = -1; k2 <= 0; ++k2) {
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(3, k2, 3), LEAF, boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(3, k2, -3), LEAF, boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(-3, k2, 3), LEAF, boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(-3, k2, -3), LEAF, boundingBox);
        }
        for (i = -3; i <= 3; ++i) {
            for (j = -3; j <= 3; ++j) {
                for (k = 1; k <= 2; ++k) {
                    if (Math.abs(i) == 3 && Math.abs(j) == 3) continue;
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, k, j), LEAF, boundingBox);
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(j, k, i), LEAF, boundingBox);
                }
            }
        }
        for (i = -2; i <= 2; ++i) {
            for (j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, 3, j), LEAF, boundingBox);
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(j, 3, i), LEAF, boundingBox);
            }
        }
        for (i = -3; i <= 3; ++i) {
            for (j = -3; j <= 3; ++j) {
                if (rand.nextInt(5) == 0) {
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, -2, j), LEAF, boundingBox);
                }
                if (rand.nextInt(5) != 0) continue;
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, -2, j), LEAF, boundingBox);
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(i, -3, j), LEAF, boundingBox);
            }
        }
        position = position.func_177984_a();
        this.setBlock(changedBlocks, worldIn, position.func_177964_d(4), LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177970_e(4), LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177965_g(4), LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177985_f(4), LEAF, boundingBox);
        for (int y = -2; y >= -4; --y) {
            for (int x = -3; x <= 4; ++x) {
                for (int z = -3; z <= 4; ++z) {
                    BlockPos pos = position.func_177982_a(x, y, z);
                    if (!SlushlandTreeFeature.func_214570_f((IWorldGenerationBaseReader)worldIn, (BlockPos)pos)) continue;
                    BlockPos westPos = pos.func_177976_e();
                    BlockPos eastPos = pos.func_177974_f();
                    BlockPos northPos = pos.func_177978_c();
                    BlockPos southPos = pos.func_177968_d();
                    int chance = 6;
                    if (rand.nextInt(chance) == 0 && SlushlandTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)westPos)) {
                        this.addVine(worldIn, westPos, VineBlock.field_176278_M);
                    }
                    if (rand.nextInt(chance) == 0 && SlushlandTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)eastPos)) {
                        this.addVine(worldIn, eastPos, VineBlock.field_176280_O);
                    }
                    if (rand.nextInt(chance) == 0 && SlushlandTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)northPos)) {
                        this.addVine(worldIn, northPos, VineBlock.field_176279_N);
                    }
                    if (rand.nextInt(chance) != 0 || !SlushlandTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)southPos)) continue;
                    this.addVine(worldIn, southPos, VineBlock.field_176273_b);
                }
            }
        }
    }

    protected void setBaseLogs(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int i;
        for (i = -3; i <= 1; ++i) {
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(2, i, 0), LOG, boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(-2, i, 0), LOG, boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, i, 2), LOG, boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, i, -2), LOG, boundingBox);
        }
        position = position.func_177981_b(2);
        this.setBlock(changedBlocks, worldIn, position.func_177978_c(), LOG, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177968_d(), LOG, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177974_f(), LOG, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177976_e(), LOG, boundingBox);
        for (i = 0; i <= 3; ++i) {
            this.setBlock(changedBlocks, worldIn, position.func_177981_b(i), LOG, boundingBox);
        }
    }

    protected void setBlock(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, BlockState state, MutableBoundingBox boundingBox) {
        if (SlushlandTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position) || worldIn.func_217375_a(position, blockState -> FluidTags.field_206959_a.func_199685_a_((Object)blockState.func_204520_s().func_206886_c()))) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position, state, boundingBox);
        }
    }

    private void addVine(IWorldGenerationReader worldIn, BlockPos pos, BooleanProperty prop) {
        BlockState blockstate = (BlockState)SkiesBlocks.bluebright_vine.func_176223_P().func_206870_a((IProperty)prop, (Comparable)Boolean.valueOf(true));
        this.func_202278_a((IWorldWriter)worldIn, pos, blockstate);
        BlockPos blockpos = pos.func_177977_b();
        for (int i = 3; SlushlandTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos) && i > 0; --i) {
            this.func_202278_a((IWorldWriter)worldIn, blockpos, blockstate);
            blockpos = blockpos.func_177977_b();
        }
    }
}

