/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LogBlock;
import net.minecraft.block.SnowBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class FrostbrightTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = SkiesBlocks.frostbright_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.frostbright_leaves.func_176223_P();
    private static final BlockState SNOW = Blocks.field_150433_aE.func_176223_P();
    private final boolean placeExtraSnow;

    public FrostbrightTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean doBlockNofityOnPlace, boolean placeExtraSnow) {
        super(config, doBlockNofityOnPlace);
        this.placeExtraSnow = placeExtraSnow;
        this.setSapling((IPlantable)SkiesBlocks.frostbright_sapling);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int z1;
        int x1;
        BlockPos pos;
        int z;
        int x;
        int i;
        int n = i = (double)rand.nextInt(7) + Math.random() < 0.1 ? 30 : 20;
        if (!this.canPlaceTree(worldIn, position, i)) {
            return false;
        }
        for (int j = 0; j < i; ++j) {
            if (FrostbrightTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(j))) {
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177981_b(j), LOG, boundingBox);
            }
            if (j >= i - 1) continue;
            if (FrostbrightTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(1, j, 0))) {
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(1, j, 0), LOG, boundingBox);
            }
            if (FrostbrightTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(1, j, 1))) {
                this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(1, j, 1), LOG, boundingBox);
            }
            if (!FrostbrightTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(0, j, 1))) continue;
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(0, j, 1), LOG, boundingBox);
        }
        for (x = -6; x <= 6; ++x) {
            for (z = -6; z <= 6; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                pos = position.func_177982_a(x > 0 ? x - 1 : x, i - 2, z > 0 ? z - 1 : z).func_177982_a(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (!(z1 < 3 || z1 < 5 && x1 < 6 || z1 == 5 && x1 < 5) && (z1 != 6 || x1 >= 3)) continue;
                this.setBlock(changedBlocks, worldIn, pos, LEAF, boundingBox);
                if (!this.placeExtraSnow) continue;
                this.setSnow(changedBlocks, worldIn, pos.func_177984_a(), SNOW, boundingBox);
            }
        }
        for (x = -5; x <= 5; ++x) {
            for (z = -5; z <= 5; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                pos = position.func_177982_a(x > 0 ? x - 1 : x, i - 1, z > 0 ? z - 1 : z).func_177982_a(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (z1 >= 3 && (z1 >= 5 || x1 >= 5) && (z1 != 5 || x1 >= 3)) continue;
                this.setBlock(changedBlocks, worldIn, pos, LEAF, boundingBox);
                if (!this.placeExtraSnow) continue;
                this.setSnow(changedBlocks, worldIn, pos.func_177984_a(), SNOW, boundingBox);
            }
        }
        for (x = -3; x <= 3; ++x) {
            for (z = -3; z <= 3; ++z) {
                if (x == 0) {
                    x = 1;
                }
                if (z == 0) {
                    z = 1;
                }
                pos = position.func_177982_a(x > 0 ? x - 1 : x, i, z > 0 ? z - 1 : z).func_177982_a(1, 0, 1);
                x1 = Math.abs(x);
                z1 = Math.abs(z);
                if (z1 + x1 > 4) continue;
                this.setBlock(changedBlocks, worldIn, pos, LEAF, boundingBox);
                if (!this.placeExtraSnow || !FrostbrightTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)pos.func_177984_a())) continue;
                this.setSnow(changedBlocks, worldIn, pos.func_177984_a(), SNOW, boundingBox);
            }
        }
        this.setLowerBranch(changedBlocks, worldIn, position.func_177982_a(rand.nextInt(2), rand.nextInt(i - 9) + 3, -1), boundingBox);
        this.setLowerBranch(changedBlocks, worldIn, position.func_177982_a(2, rand.nextInt(i - 9) + 3, rand.nextInt(2)), boundingBox);
        this.setLowerBranch(changedBlocks, worldIn, position.func_177982_a(rand.nextInt(2), rand.nextInt(i - 9) + 3, 2), boundingBox);
        this.setLowerBranch(changedBlocks, worldIn, position.func_177982_a(-1, rand.nextInt(i - 9) + 3, rand.nextInt(2)), boundingBox);
        for (int c = 0; c < 4; ++c) {
            int l;
            int y = i - 5 - rand.nextInt(2);
            int xz = rand.nextInt(2);
            int length = rand.nextInt(2) + 1;
            for (l = y; l < i - 2; ++l) {
                if (c == 0) {
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(2 + length, l + 1, xz), LOG, boundingBox);
                }
                if (c == 1) {
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(xz, l + 1, 2 + length), LOG, boundingBox);
                }
                if (c == 2) {
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(-1 - length, l + 1, xz), LOG, boundingBox);
                }
                if (c != 3) continue;
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(xz, l + 1, -1 - length), LOG, boundingBox);
            }
            for (l = 0; l < length + 1; ++l) {
                if (c == 0) {
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(2 + l, y, xz), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X), boundingBox);
                }
                if (c == 1) {
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(xz, y, 2 + l), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Z), boundingBox);
                }
                if (c == 2) {
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(-1 - l, y, xz), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X), boundingBox);
                }
                if (c != 3) continue;
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(xz, y, -1 - l), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Z), boundingBox);
            }
        }
        for (x = -1; x <= 2; ++x) {
            for (z = -1; z <= 2; ++z) {
                if (!((x == -1 || x == 2) ^ (z == -1 || z == 2))) continue;
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, 0, z), LOG, boundingBox);
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, 1, z), LOG, boundingBox);
                if (!rand.nextBoolean()) continue;
                this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, 2, z), LOG, boundingBox);
            }
        }
        if (this.placeExtraSnow) {
            this.placeSnowCircle(worldIn, position);
        }
        return true;
    }

    protected void setLowerBranch(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, MutableBoundingBox boundingBox) {
        this.setBlock(changedBlocks, worldIn, position, LOG, boundingBox);
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = 0; y < 2; ++y) {
                    if (y == 1 && Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                    this.setBlock(changedBlocks, worldIn, position.func_177982_a(x, y, z), LEAF, boundingBox);
                }
            }
        }
    }

    protected void placeSnowCircle(IWorldGenerationReader worldIn, BlockPos center) {
        for (int i = -5; i <= 6; ++i) {
            for (int j = -5; j <= 6; ++j) {
                if (!(Math.random() > 0.5)) continue;
                this.placeSnowAt(worldIn, center.func_177982_a(i, 0, j));
            }
        }
    }

    protected void placeSnowAt(IWorldGenerationReader worldIn, BlockPos pos) {
        for (int i = 2; i >= -3; --i) {
            BlockPos blockpos = pos.func_177981_b(i);
            if (FrostbrightTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos, (IPlantable)this.getSapling()) && worldIn.func_217375_a(blockpos.func_177984_a(), state -> state.func_177230_c() == Blocks.field_150350_a)) {
                int layers = Math.random() > 0.8 ? 2 : 1;
                worldIn.func_180501_a(blockpos.func_177984_a(), (BlockState)SNOW.func_206870_a((IProperty)SnowBlock.field_176315_a, (Comparable)Integer.valueOf(layers)), 2);
                if (!worldIn.func_217375_a(blockpos, state -> state.func_196959_b((IProperty)BlockStateProperties.field_208196_w))) break;
                worldIn.func_217375_a(blockpos, state -> worldIn.func_180501_a(blockpos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208196_w, (Comparable)Boolean.valueOf(true)), 2));
                break;
            }
            if (!FrostbrightTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos) && i < 0) break;
        }
    }

    public boolean canPlaceTree(IWorldGenerationReader worldIn, BlockPos position, int height) {
        return FrostbrightTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling()) && FrostbrightTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(1, -1, 0), (IPlantable)this.getSapling()) && FrostbrightTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(1, -1, 1), (IPlantable)this.getSapling()) && FrostbrightTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177982_a(0, -1, 1), (IPlantable)this.getSapling());
    }

    protected void setBlock(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, BlockState state, MutableBoundingBox boundingBox) {
        if (FrostbrightTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position) || worldIn.func_217375_a(position, blockState -> blockState.func_177230_c().equals(Blocks.field_150433_aE))) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position, state, boundingBox);
        }
    }

    protected void setSnow(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, BlockState state, MutableBoundingBox boundingBox) {
        if (FrostbrightTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)position)) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position, state, boundingBox);
        }
    }
}

