/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everbright.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class BluebrightTreeFeature
extends AbstractTreeFeature<NoFeatureConfig> {
    private static final BlockState LOG = SkiesBlocks.bluebright_log.func_176223_P();
    private static final BlockState LEAF = SkiesBlocks.bluebright_leaves.func_176223_P();
    private int minTreeHeight;

    public BluebrightTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> config, boolean notify, boolean useExtraRandomHeightIn, int minTreeHeightIn) {
        super(config, notify);
        this.minTreeHeight = minTreeHeightIn;
        this.setSapling((IPlantable)SkiesBlocks.bluebright_sapling);
    }

    protected boolean func_208519_a(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        int h = rand.nextInt(3) + this.minTreeHeight;
        boolean flag = true;
        if (BluebrightTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177977_b(), (IPlantable)this.getSapling()) && position.func_177956_o() < worldIn.getMaxHeight() - h - 1) {
            if (position.func_177956_o() >= 1 && position.func_177956_o() + h + 1 <= worldIn.getMaxHeight()) {
                int i;
                for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + h; ++j) {
                    int k = 1;
                    if (j == position.func_177956_o()) {
                        k = 0;
                    }
                    if (j >= position.func_177956_o() + 1 + h - 2) {
                        k = 2;
                    }
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                    for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                        for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                            if (j >= 0 && j < worldIn.getMaxHeight()) {
                                if (AbstractTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                                flag = false;
                                continue;
                            }
                            flag = false;
                        }
                    }
                }
                if (!flag) {
                    return false;
                }
                this.setLeafBall(changedBlocks, worldIn, rand, position.func_177982_a(0, h - 2, 0), boundingBox);
                for (int j3 = 0; j3 < h; ++j3) {
                    if (!BluebrightTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(j3))) continue;
                    this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177981_b(j3), LOG, boundingBox);
                }
                int iPosX = h - 4 - rand.nextInt(3);
                int iNegX = h - 4 - rand.nextInt(3);
                int iPosZ = h - 4 - rand.nextInt(3);
                int iNegZ = h - 4 - rand.nextInt(3);
                for (i = 1; i <= 3; ++i) {
                    this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(i, iPosX + i, 0), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X), boundingBox);
                    this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(0, iPosZ + i, i), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Z), boundingBox);
                    if (i != 3) continue;
                    this.setLeafBall(changedBlocks, worldIn, rand, position.func_177982_a(i, iPosX + 2, 0), boundingBox);
                    this.setLeafBall(changedBlocks, worldIn, rand, position.func_177982_a(0, iPosZ + 2, i), boundingBox);
                }
                for (i = -1; i >= -3; --i) {
                    this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(i, iNegX - i, 0), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.X), boundingBox);
                    this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position.func_177982_a(0, iNegZ - i, i), (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)Direction.Axis.Z), boundingBox);
                    if (i != -3) continue;
                    this.setLeafBall(changedBlocks, worldIn, rand, position.func_177982_a(i, iNegX + 2, 0), boundingBox);
                    this.setLeafBall(changedBlocks, worldIn, rand, position.func_177982_a(0, iNegZ + 2, i), boundingBox);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected void setLeafBall(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, Random rand, BlockPos position, MutableBoundingBox boundingBox) {
        for (int i = 0; i <= 2; ++i) {
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(1, i, 0), LEAF, boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, i, 1), LEAF, boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, i, 0), LEAF, boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, i, -1), LEAF, boundingBox);
            this.setBlock(changedBlocks, worldIn, position.func_177982_a(-1, i, 0), LEAF, boundingBox);
        }
        this.setBlock(changedBlocks, worldIn, position.func_177982_a(1, 1, 1), LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177982_a(1, 1, -1), LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177982_a(-1, 1, 1), LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177982_a(-1, 1, -1), LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, -1, 0), LEAF, boundingBox);
        this.setBlock(changedBlocks, worldIn, position.func_177982_a(0, 3, 0), LEAF, boundingBox);
    }

    protected void setBlock(Set<BlockPos> changedBlocks, IWorldGenerationReader worldIn, BlockPos position, BlockState state, MutableBoundingBox boundingBox) {
        if (BluebrightTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position)) {
            this.func_208520_a(changedBlocks, (IWorldWriter)worldIn, position, state, boundingBox);
        }
    }
}

