/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.TextFormatting;

public class EnumHelper {
    private static Object reflectionFactory;
    private static Method newConstructorAccessor;
    private static Method newInstance;

    public static Rarity createRarity(String value, Object ... additionalValues) {
        return EnumHelper.create(Rarity.class, value, Rarity.values().length, new Class[]{TextFormatting.class}, additionalValues);
    }

    public static <T extends Enum<?>> T create(Class<T> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) {
        try {
            return EnumHelper.makeEnum(enumClass, value, ordinal, additionalTypes, additionalValues);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T extends Enum<?>> T makeEnum(Class<T> enumClass, String value, int ordinal, Class<?>[] additionalTypes, Object[] additionalValues) throws Exception {
        Object[] params = new Object[additionalValues.length + 2];
        params[0] = value;
        params[1] = ordinal;
        System.arraycopy(additionalValues, 0, params, 2, additionalValues.length);
        return (T)((Enum)enumClass.cast(newInstance.invoke(EnumHelper.getConstructorAccessor(enumClass, additionalTypes), params)));
    }

    private static Object getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws Exception {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return newConstructorAccessor.invoke(reflectionFactory, enumClass.getDeclaredConstructor(parameterTypes));
    }

    static {
        try {
            reflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]).invoke(null, new Object[0]);
            newConstructorAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newConstructorAccessor", Constructor.class);
            newInstance = Class.forName("sun.reflect.ConstructorAccessor").getDeclaredMethod("newInstance", Object[].class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

