/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.tile_entity;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesTileEntityTypes;
import net.minecraft.block.Block;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SkyChestTileEntity
extends ChestTileEntity {
    private final TranslationTextComponent localizedName;

    public SkyChestTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
        this.localizedName = new TranslationTextComponent("block.blue_skies." + typeIn.getRegistryName().func_110623_a(), new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-1, 0, -1), this.field_174879_c.func_177982_a(2, 2, 2));
    }

    public static SkyChestTileEntity getFromBlock(Block blockIn) {
        SkyChestTileEntity tile = blockIn == SkiesBlocks.bluebright_chest ? new BluebrightChestTileEntity() : (blockIn == SkiesBlocks.starlit_chest ? new StarlitChestTileEntity() : (blockIn == SkiesBlocks.frostbright_chest ? new FrostbrightChestTileEntity() : (blockIn == SkiesBlocks.lunar_chest ? new LunarChestTileEntity() : (blockIn == SkiesBlocks.dusk_chest ? new DuskChestTileEntity() : (blockIn == SkiesBlocks.maple_chest ? new MapleChestTileEntity() : new CherryChestTileEntity())))));
        return tile;
    }

    protected ITextComponent func_213907_g() {
        return this.localizedName;
    }

    public static class CherryChestTileEntity
    extends SkyChestTileEntity {
        public CherryChestTileEntity() {
            super(SkiesTileEntityTypes.CHERRY_CHEST);
        }
    }

    public static class MapleChestTileEntity
    extends SkyChestTileEntity {
        public MapleChestTileEntity() {
            super(SkiesTileEntityTypes.MAPLE_CHEST);
        }
    }

    public static class DuskChestTileEntity
    extends SkyChestTileEntity {
        public DuskChestTileEntity() {
            super(SkiesTileEntityTypes.DUSK_CHEST);
        }
    }

    public static class LunarChestTileEntity
    extends SkyChestTileEntity {
        public LunarChestTileEntity() {
            super(SkiesTileEntityTypes.LUNAR_CHEST);
        }
    }

    public static class FrostbrightChestTileEntity
    extends SkyChestTileEntity {
        public FrostbrightChestTileEntity() {
            super(SkiesTileEntityTypes.FROSTBRIGHT_CHEST);
        }
    }

    public static class StarlitChestTileEntity
    extends SkyChestTileEntity {
        public StarlitChestTileEntity() {
            super(SkiesTileEntityTypes.STARLIT_CHEST);
        }
    }

    public static class BluebrightChestTileEntity
    extends SkyChestTileEntity {
        public BluebrightChestTileEntity() {
            super(SkiesTileEntityTypes.BLUEBRIGHT_CHEST);
        }
    }
}

