/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.ImmutableSet;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesRegistry;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.Collection;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class SkiesVillagers {
    public static final PointOfInterestType STAR_EMITTER = new PointOfInterestType("star_emitter", SkiesVillagers.getAllStates(SkiesBlocks.star_emitter), 1, SkiesSounds.BLOCK_KEYSTONE_LOCKED, 1);
    public static final PointOfInterestType TROUGH = new PointOfInterestType("trough", SkiesVillagers.getAllStates(SkiesBlocks.trough), 1, SkiesSounds.BLOCK_KEYSTONE_LOCKED, 1);
    public static final PointOfInterestType TOOL_BOX = new PointOfInterestType("tool_box", SkiesVillagers.getAllStates(SkiesBlocks.tool_box), 1, SkiesSounds.BLOCK_KEYSTONE_LOCKED, 1);
    public static final PointOfInterestType SUMMONING_TABLE = new PointOfInterestType("summoning_table", SkiesVillagers.getAllStates(SkiesBlocks.summoning_table), 1, SkiesSounds.BLOCK_KEYSTONE_LOCKED, 1);
    public static final PointOfInterestType ALCHEMY_TABLE = new PointOfInterestType("alchemy_table", SkiesVillagers.getAllStates(SkiesBlocks.alchemy_table), 1, SkiesSounds.BLOCK_KEYSTONE_LOCKED, 1);
    public static final PointOfInterestType EMPTY_WORKSTATION = new PointOfInterestType("empty_workstation", (Set)ImmutableSet.of(), 1, SkiesSounds.BLOCK_KEYSTONE_LOCKED, 1);
    public static final VillagerProfession STARGAZER = new VillagerProfession("stargazer", STAR_EMITTER, ImmutableSet.of(), ImmutableSet.of());
    public static final VillagerProfession WRANGLER = new VillagerProfession("wrangler", TROUGH, ImmutableSet.of(), ImmutableSet.of());
    public static final VillagerProfession SHOVELER = new VillagerProfession("shoveler", TOOL_BOX, ImmutableSet.of(), ImmutableSet.of());
    public static final VillagerProfession NIGHTWATCHER = new VillagerProfession("nightwatcher", EMPTY_WORKSTATION, ImmutableSet.of(), ImmutableSet.of());
    public static final VillagerProfession SUMMONER = new VillagerProfession("summoner", SUMMONING_TABLE, ImmutableSet.of(), ImmutableSet.of());
    public static final VillagerProfession ALCHEMIST = new VillagerProfession("alchemist", ALCHEMY_TABLE, ImmutableSet.of(), ImmutableSet.of());

    public static void initInterests(RegistryEvent.Register<PointOfInterestType> event) {
        SkiesRegistry.register(event.getRegistry(), "star_emitter", STAR_EMITTER);
        SkiesRegistry.register(event.getRegistry(), "trough", TROUGH);
        SkiesRegistry.register(event.getRegistry(), "tool_box", TOOL_BOX);
        SkiesRegistry.register(event.getRegistry(), "summoning_table", SUMMONING_TABLE);
        SkiesRegistry.register(event.getRegistry(), "alchemy_table", ALCHEMY_TABLE);
        SkiesRegistry.register(event.getRegistry(), "empty_workstation", EMPTY_WORKSTATION);
        SkiesVillagers.addPointToVanilla(STAR_EMITTER);
        SkiesVillagers.addPointToVanilla(TROUGH);
        SkiesVillagers.addPointToVanilla(TOOL_BOX);
        SkiesVillagers.addPointToVanilla(SUMMONING_TABLE);
        SkiesVillagers.addPointToVanilla(ALCHEMY_TABLE);
    }

    public static void init(RegistryEvent.Register<VillagerProfession> event) {
        SkiesRegistry.register(event.getRegistry(), "stargazer", STARGAZER);
        SkiesRegistry.register(event.getRegistry(), "wrangler", WRANGLER);
        SkiesRegistry.register(event.getRegistry(), "shoveler", SHOVELER);
        SkiesRegistry.register(event.getRegistry(), "nightwatcher", NIGHTWATCHER);
        SkiesRegistry.register(event.getRegistry(), "summoner", SUMMONER);
        SkiesRegistry.register(event.getRegistry(), "alchemist", ALCHEMIST);
    }

    private static void addPointToVanilla(PointOfInterestType type) {
        try {
            ObfuscationReflectionHelper.findMethod(PointOfInterestType.class, (String)"func_221052_a", (Class[])new Class[]{PointOfInterestType.class}).invoke(null, type);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Set<BlockState> getAllStates(Block block) {
        return ImmutableSet.copyOf((Collection)block.func_176194_O().func_177619_a());
    }
}

