/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.client.particle.EverbrightPortalParticle;
import com.legacy.blue_skies.client.particle.EverdawnPortalParticle;
import com.legacy.blue_skies.client.particle.PoisonParticle;
import com.legacy.blue_skies.client.particle.SkyFlameParticle;
import com.legacy.blue_skies.client.particle.StarFlareParticle;
import com.legacy.blue_skies.client.particle.data.PoisonData;
import com.legacy.blue_skies.client.particle.data.StarFlareData;
import com.legacy.blue_skies.registries.SkiesRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="blue_skies")
public class SkiesParticles {
    public static final BasicParticleType BLUE_FLAME = null;
    public static final BasicParticleType BLACK_FLAME = null;
    public static final BasicParticleType EVERBRIGHT_PORTAL = null;
    public static final BasicParticleType EVERDAWN_PORTAL = null;
    public static final ParticleType<PoisonData> POISON = null;
    public static final ParticleType<StarFlareData> STAR_FLARE = null;

    public static void init(RegistryEvent.Register<ParticleType<?>> event) {
        SkiesParticles.register(event, "blue_flame", false);
        SkiesParticles.register(event, "black_flame", false);
        SkiesParticles.register(event, "everbright_portal", false);
        SkiesParticles.register(event, "everdawn_portal", false);
        SkiesParticles.register(event, "star_flare", true, StarFlareData.DESERIALIZER);
        SkiesParticles.register(event, "poison", false, PoisonData.DESERIALIZER);
    }

    private static void register(RegistryEvent.Register<ParticleType<?>> event, String key, boolean alwaysVisible) {
        SkiesRegistry.register(event.getRegistry(), key, new BasicParticleType(alwaysVisible));
    }

    private static <T extends IParticleData> void register(RegistryEvent.Register<ParticleType<?>> event, String key, boolean alwaysVisible, IParticleData.IDeserializer<T> deserializer) {
        SkiesRegistry.register(event.getRegistry(), key, new ParticleType(alwaysVisible, deserializer));
    }

    public static void registerFactories(ParticleFactoryRegisterEvent event) {
        SkiesParticles.registerFactory(BLUE_FLAME, SkyFlameParticle.Factory::new);
        SkiesParticles.registerFactory(BLACK_FLAME, SkyFlameParticle.Factory::new);
        SkiesParticles.registerFactory(EVERBRIGHT_PORTAL, EverbrightPortalParticle.Factory::new);
        SkiesParticles.registerFactory(EVERDAWN_PORTAL, EverdawnPortalParticle.Factory::new);
        SkiesParticles.registerFactory(POISON, PoisonParticle.Factory::new);
        SkiesParticles.registerFactory(STAR_FLARE, StarFlareParticle.Factory::new);
    }

    private static <T extends IParticleData> void registerFactory(ParticleType<T> particleTypeIn, ParticleManager.IParticleMetaFactory<T> particleMetaFactoryIn) {
        Minecraft.func_71410_x().field_71452_i.func_215234_a(particleTypeIn, particleMetaFactoryIn);
    }
}

