/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.blocks.natural.RaspberryBushBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesRegistry;
import com.legacy.blue_skies.registries.SkiesStructurePieceTypes;
import com.legacy.blue_skies.registries.SkiesStructureProcessors;
import com.legacy.blue_skies.world.everbright.gen.features.BluebrightTreeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.ChilledLilyFeature;
import com.legacy.blue_skies.world.everbright.gen.features.FrostbrightTreeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.SlushlandTreeFeature;
import com.legacy.blue_skies.world.everbright.gen.features.StarlitTreeFeature;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonConfig;
import com.legacy.blue_skies.world.everbright.gen.structures.blinding_dungeon.EverbrightBlindingDungeonStructure;
import com.legacy.blue_skies.world.everbright.gen.structures.dungeon.EverbrightDungeonConfig;
import com.legacy.blue_skies.world.everbright.gen.structures.dungeon.EverbrightDungeonStructure;
import com.legacy.blue_skies.world.everdawn.gen.features.DuskTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.LargeDuskTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.LunarTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.MapleTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.MoonstoneSpikeFeature;
import com.legacy.blue_skies.world.everdawn.gen.features.NectarineTreeFeature;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonConfig;
import com.legacy.blue_skies.world.everdawn.gen.structures.blinding_dungeon.EverdawnBlindingDungeonStructure;
import com.legacy.blue_skies.world.general_features.CherryTreeFeature;
import com.legacy.blue_skies.world.general_features.SkiesCanyonWorldCarver;
import com.legacy.blue_skies.world.general_features.SkiesCaveWorldCarver;
import com.legacy.blue_skies.world.general_features.SkiesLakesFeature;
import com.legacy.blue_skies.world.general_features.SkiesOreFeature;
import com.legacy.blue_skies.world.general_features.SkyFlowersFeature;
import com.legacy.blue_skies.world.general_features.UnderwaterSkiesCanyonWorldCarver;
import com.legacy.blue_skies.world.general_features.UnderwaterSkiesCaveWorldCarver;
import com.legacy.blue_skies.world.general_features.config.SkiesOreFeatureConfig;
import com.legacy.blue_skies.world.general_features.structures.GatekeeperHouseConfig;
import com.legacy.blue_skies.world.general_features.structures.GatekeeperHouseStructure;
import java.util.Locale;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.LakesConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.LakeChanceConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="blue_skies")
public class SkiesFeatures {
    public static final AbstractTreeFeature<NoFeatureConfig> BLUEBRIGHT_TREE = new BluebrightTreeFeature(NoFeatureConfig::func_214639_a, false, false, 5);
    public static final AbstractTreeFeature<NoFeatureConfig> SLUSHLAND_TREE = new SlushlandTreeFeature(NoFeatureConfig::func_214639_a, false, false);
    public static final AbstractTreeFeature<NoFeatureConfig> STARLIT_TREE = new StarlitTreeFeature(NoFeatureConfig::func_214639_a, false);
    public static final AbstractTreeFeature<NoFeatureConfig> FROSTBRIGHT_TREE = new FrostbrightTreeFeature(NoFeatureConfig::func_214639_a, false, true);
    public static final AbstractTreeFeature<NoFeatureConfig> LUNAR_TREE = new LunarTreeFeature(NoFeatureConfig::func_214639_a, false, false, 5);
    public static final AbstractTreeFeature<NoFeatureConfig> DUSK_TREE = new DuskTreeFeature(NoFeatureConfig::func_214639_a, false, 5);
    public static final AbstractTreeFeature<NoFeatureConfig> LARGE_DUSK_TREE = new LargeDuskTreeFeature(NoFeatureConfig::func_214639_a, false);
    public static final AbstractTreeFeature<NoFeatureConfig> MAPLE_TREE = new MapleTreeFeature(NoFeatureConfig::func_214639_a, false);
    public static final AbstractTreeFeature<NoFeatureConfig> NECTARINE_TREE = new NectarineTreeFeature(NoFeatureConfig::func_214639_a, false);
    public static final AbstractTreeFeature<NoFeatureConfig> CHERRY_TREE = new CherryTreeFeature(NoFeatureConfig::func_214639_a, false);
    public static final Feature<NoFeatureConfig> CHILLED_LILY = new ChilledLilyFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> MOONSTONE_SPIKE = new MoonstoneSpikeFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<LakesConfig> EVERBRIGHT_LAKE = new SkiesLakesFeature(LakesConfig::func_214712_a, false);
    public static final Feature<LakesConfig> EVERDAWN_LAKE = new SkiesLakesFeature(LakesConfig::func_214712_a, true);
    public static final Feature<SkiesOreFeatureConfig> ORE = new SkiesOreFeature(SkiesOreFeatureConfig::deserialize);
    public static final Structure<EverbrightDungeonConfig> EVERBRIGHT_DUNGEON = new EverbrightDungeonStructure(EverbrightDungeonConfig::deserialize);
    public static final Structure<EverbrightBlindingDungeonConfig> EVERBRIGHT_BLINDING_DUNGEON = new EverbrightBlindingDungeonStructure(EverbrightBlindingDungeonConfig::deserialize);
    public static final Structure<EverdawnBlindingDungeonConfig> EVERDAWN_BLINDING_DUNGEON = new EverdawnBlindingDungeonStructure(EverdawnBlindingDungeonConfig::deserialize);
    public static final Structure<GatekeeperHouseConfig> GATEKEEPER_HOUSE = new GatekeeperHouseStructure(GatekeeperHouseConfig::deserialize);

    public static void init(RegistryEvent.Register<Feature<?>> event) {
        SkiesStructurePieceTypes.init();
        SkiesStructureProcessors.init();
        SkiesRegistry.register(event.getRegistry(), "bluebright_tree", BLUEBRIGHT_TREE);
        SkiesRegistry.register(event.getRegistry(), "slushland_tree", SLUSHLAND_TREE);
        SkiesRegistry.register(event.getRegistry(), "starlit_tree", STARLIT_TREE);
        SkiesRegistry.register(event.getRegistry(), "frostbright_tree", FROSTBRIGHT_TREE);
        SkiesRegistry.register(event.getRegistry(), "lunar_tree", LUNAR_TREE);
        SkiesRegistry.register(event.getRegistry(), "dusk_tree", DUSK_TREE);
        SkiesRegistry.register(event.getRegistry(), "large_dusk_tree", LARGE_DUSK_TREE);
        SkiesRegistry.register(event.getRegistry(), "maple_tree", MAPLE_TREE);
        SkiesRegistry.register(event.getRegistry(), "nectarine_tree", NECTARINE_TREE);
        SkiesRegistry.register(event.getRegistry(), "cherry_tree", CHERRY_TREE);
        SkiesRegistry.register(event.getRegistry(), "chilled_lily", CHILLED_LILY);
        SkiesRegistry.register(event.getRegistry(), "moonstone_spike", MOONSTONE_SPIKE);
        SkiesRegistry.register(event.getRegistry(), "everbright_lake", EVERBRIGHT_LAKE);
        SkiesRegistry.register(event.getRegistry(), "everdawn_lake", EVERDAWN_LAKE);
        SkiesRegistry.register(event.getRegistry(), "ore", ORE);
        SkiesFeatures.registerStructure(event.getRegistry(), "everbright_dungeon", EVERBRIGHT_DUNGEON);
        SkiesFeatures.registerStructure(event.getRegistry(), "everbright_blinding_dungeon", EVERBRIGHT_BLINDING_DUNGEON);
        SkiesFeatures.registerStructure(event.getRegistry(), "everdawn_blinding_dungeon", EVERDAWN_BLINDING_DUNGEON);
        SkiesFeatures.registerStructure(event.getRegistry(), "gatekeeper_house", GATEKEEPER_HOUSE);
    }

    private static void registerStructure(IForgeRegistry<Feature<?>> registry, String key, Structure<?> structure) {
        SkiesRegistry.register(registry, key, structure);
        Registry.func_218322_a((Registry)Registry.field_218361_B, (ResourceLocation)BlueSkies.locate(key.toLowerCase()), structure);
        Feature.field_202300_at.put((Object)BlueSkies.find(key.toLowerCase(Locale.ROOT)), structure);
    }

    public static void addBrightStructures(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Biome.func_222280_a(EVERBRIGHT_DUNGEON, (IFeatureConfig)new EverbrightDungeonConfig(), (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e));
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(EVERBRIGHT_BLINDING_DUNGEON, (IFeatureConfig)new EverbrightBlindingDungeonConfig(), (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e));
    }

    public static void addDawnStructures(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, Biome.func_222280_a(EVERDAWN_BLINDING_DUNGEON, (IFeatureConfig)new EverdawnBlindingDungeonConfig(), (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e));
    }

    public static void addDefaultBrightOres(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.TURQUOISE, SkiesBlocks.coarse_turquoise_dirt.func_176223_P(), 33), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 0, 0, 256)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.TURQUOISE, SkiesBlocks.everbright_moonstone_ore.func_176223_P(), 14), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(20, 0, 0, 128)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.TURQUOISE, SkiesBlocks.everbright_pyrope_ore.func_176223_P(), 7), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(17, 0, 0, 84)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.TURQUOISE, SkiesBlocks.everbright_turquoise_ore.func_176223_P(), 5), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(15, 0, 0, 55)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.TURQUOISE, SkiesBlocks.everbright_diopside_ore.func_176223_P(), 4), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(2, 0, 0, 20)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.TURQUOISE, SkiesBlocks.everbright_charoite_ore.func_176223_P(), 4), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 0, 0, 15)));
    }

    public static void addDefaultDawnOres(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.LUNAR, SkiesBlocks.coarse_lunar_dirt.func_176223_P(), 33), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 0, 0, 256)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.LUNAR, SkiesBlocks.everdawn_moonstone_ore.func_176223_P(), 14), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(20, 0, 0, 128)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.LUNAR, SkiesBlocks.everdawn_pyrope_ore.func_176223_P(), 7), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(17, 0, 0, 84)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.LUNAR, SkiesBlocks.everdawn_turquoise_ore.func_176223_P(), 5), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(15, 0, 0, 55)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.LUNAR, SkiesBlocks.everdawn_diopside_ore.func_176223_P(), 4), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(2, 0, 0, 20)));
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.LUNAR, SkiesBlocks.everdawn_charoite_ore.func_176223_P(), 4), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(1, 0, 0, 15)));
    }

    public static void addHorizoniteOre(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, Biome.func_222280_a(ORE, (IFeatureConfig)new SkiesOreFeatureConfig(SkiesOreFeatureConfig.FillerBlockType.LUNAR, SkiesBlocks.horizonite_ore.func_176223_P(), 4), (Placement)Placement.field_215028_n, (IPlacementConfig)new CountRangeConfig(10, 0, 0, 25)));
    }

    public static void addCarvers(Biome biomeIn) {
        biomeIn.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)new SkiesCaveWorldCarver(ProbabilityConfig::func_214645_a, 256), (ICarverConfig)new ProbabilityConfig(0.14285715f)));
        biomeIn.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)new SkiesCanyonWorldCarver(ProbabilityConfig::func_214645_a), (ICarverConfig)new ProbabilityConfig(0.02f)));
    }

    public static void addOceanCarvers(Biome biomeIn) {
        biomeIn.func_203609_a(GenerationStage.Carving.LIQUID, Biome.func_203606_a((WorldCarver)new UnderwaterSkiesCaveWorldCarver(ProbabilityConfig::func_214645_a), (ICarverConfig)new ProbabilityConfig(0.02f)));
        biomeIn.func_203609_a(GenerationStage.Carving.LIQUID, Biome.func_203606_a((WorldCarver)new UnderwaterSkiesCanyonWorldCarver(ProbabilityConfig::func_214645_a), (ICarverConfig)new ProbabilityConfig(0.06666667f)));
        biomeIn.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)new SkiesCaveWorldCarver(ProbabilityConfig::func_214645_a, 256), (ICarverConfig)new ProbabilityConfig(0.14285715f)));
        biomeIn.func_203609_a(GenerationStage.Carving.AIR, Biome.func_203606_a((WorldCarver)new SkiesCanyonWorldCarver(ProbabilityConfig::func_214645_a), (ICarverConfig)new ProbabilityConfig(0.02f)));
    }

    public static void addBrightLakes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a(EVERBRIGHT_LAKE, (IFeatureConfig)new LakesConfig(Blocks.field_150355_j.func_176223_P()), (Placement)Placement.field_215006_E, (IPlacementConfig)new LakeChanceConfig(4)));
    }

    public static void addDawnLakes(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, Biome.func_222280_a(EVERDAWN_LAKE, (IFeatureConfig)new LakesConfig(Blocks.field_150355_j.func_176223_P()), (Placement)Placement.field_215006_E, (IPlacementConfig)new LakeChanceConfig(4)));
    }

    public static void addBrightFlowers(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new SkyFlowersFeature(NoFeatureConfig::func_214639_a, SkiesBlocks.camellia.func_176223_P()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(4)));
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new SkyFlowersFeature(NoFeatureConfig::func_214639_a, (BlockState)SkiesBlocks.raspberry_bush.func_176223_P().func_206870_a((IProperty)RaspberryBushBlock.MATURE, (Comparable)Boolean.valueOf(true))), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(2)));
    }

    public static void addDawnFlowers(Biome biomeIn) {
        biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Biome.func_222280_a((Feature)new SkyFlowersFeature(NoFeatureConfig::func_214639_a, SkiesBlocks.moonlit_bloom.func_176223_P()), (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215017_c, (IPlacementConfig)new FrequencyConfig(2)));
    }
}

