/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.entities.hostile.ArmoredFrostSpiritEntity;
import com.legacy.blue_skies.entities.hostile.CrynocerousEntity;
import com.legacy.blue_skies.entities.hostile.FrostSpiritEntity;
import com.legacy.blue_skies.entities.hostile.NyctoflyEntity;
import com.legacy.blue_skies.entities.hostile.VenomSpiderEntity;
import com.legacy.blue_skies.entities.hostile.boss.AlchemistEntity;
import com.legacy.blue_skies.entities.hostile.boss.SummonerEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.ArtificialGolemEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.DecayingSpikeEntity;
import com.legacy.blue_skies.entities.hostile.boss.summons.StrangeLightningEntity;
import com.legacy.blue_skies.entities.passive.AzulfoEntity;
import com.legacy.blue_skies.entities.passive.CosmicFoxEntity;
import com.legacy.blue_skies.entities.passive.CrystalCamelEntity;
import com.legacy.blue_skies.entities.passive.FireflyEntity;
import com.legacy.blue_skies.entities.passive.ReindeerEntity;
import com.legacy.blue_skies.entities.passive.StardustRamEntity;
import com.legacy.blue_skies.entities.projectile.FluctuantSphereEntity;
import com.legacy.blue_skies.entities.projectile.VenomSpitEntity;
import com.legacy.blue_skies.entities.villager.GatekeeperEntity;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="blue_skies")
public class SkiesEntityTypes {
    public static final EntityType<AzulfoEntity> AZULFO = SkiesEntityTypes.buildEntity("azulfo", EntityType.Builder.func_220322_a(AzulfoEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(2.0f, 2.3f));
    public static final EntityType<StardustRamEntity> STARDUST_RAM = SkiesEntityTypes.buildEntity("stardust_ram", EntityType.Builder.func_220322_a(StardustRamEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.4f, 1.7f));
    public static final EntityType<ReindeerEntity> REINDEER = SkiesEntityTypes.buildEntity("reindeer", EntityType.Builder.func_220322_a(ReindeerEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.5f, 1.5f).func_220320_c());
    public static final EntityType<FrostSpiritEntity> FROST_SPIRIT = SkiesEntityTypes.buildEntity("frost_spirit", EntityType.Builder.func_220322_a(FrostSpiritEntity::new, (EntityClassification)EntityClassification.AMBIENT).func_220321_a(0.6f, 0.6f));
    public static final EntityType<ArmoredFrostSpiritEntity> ARMORED_FROST_SPIRIT = SkiesEntityTypes.buildEntity("armored_frost_spirit", EntityType.Builder.func_220322_a(ArmoredFrostSpiritEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<CrynocerousEntity> CRYNOCEROUS = SkiesEntityTypes.buildEntity("crynocerous", EntityType.Builder.func_220322_a(CrynocerousEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(2.0f, 2.3f));
    public static final EntityType<FireflyEntity> FIREFLY = SkiesEntityTypes.buildEntity("firefly", EntityType.Builder.func_220322_a(FireflyEntity::new, (EntityClassification)EntityClassification.AMBIENT).func_220321_a(0.6f, 0.6f));
    public static final EntityType<CosmicFoxEntity> COSMIC_FOX = SkiesEntityTypes.buildEntity("cosmic_fox", EntityType.Builder.func_220322_a(CosmicFoxEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.7f, 0.75f));
    public static final EntityType<CrystalCamelEntity> CRYSTAL_CAMEL = SkiesEntityTypes.buildEntity("crystal_camel", EntityType.Builder.func_220322_a(CrystalCamelEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.5f, 2.2f));
    public static final EntityType<NyctoflyEntity> NYCTOFLY = SkiesEntityTypes.buildEntity("nyctofly", EntityType.Builder.func_220322_a(NyctoflyEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.2f, 0.8f));
    public static final EntityType<VenomSpiderEntity> VENOM_SPIDER = SkiesEntityTypes.buildEntity("venom_spider", EntityType.Builder.func_220322_a(VenomSpiderEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.4f, 0.9f));
    public static final EntityType<VenomSpitEntity> VENOM_SPIT = SkiesEntityTypes.buildEntity("venom_spit", EntityType.Builder.func_220322_a(VenomSpitEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(VenomSpitEntity::new).setShouldReceiveVelocityUpdates(true).func_220321_a(0.25f, 0.25f));
    public static final EntityType<GatekeeperEntity> GATEKEEPER = SkiesEntityTypes.buildEntity("gatekeeper", EntityType.Builder.func_220322_a(GatekeeperEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 1.95f));
    public static final EntityType<ArtificialGolemEntity> ARTIFICIAL_GOLEM = SkiesEntityTypes.buildEntity("artificial_golem", EntityType.Builder.func_220322_a(ArtificialGolemEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.0f, 2.1f).func_220320_c());
    public static final EntityType<StrangeLightningEntity> STRANGE_LIGHTNING = SkiesEntityTypes.buildEntity("strange_lightning", EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MISC).setCustomClientFactory(StrangeLightningEntity::new).func_220321_a(0.0f, 0.0f));
    public static final EntityType<FluctuantSphereEntity> FLUCTUANT_SPHERE = SkiesEntityTypes.buildEntity("fluctuant_sphere", EntityType.Builder.func_220319_a((EntityClassification)EntityClassification.MISC).setCustomClientFactory(FluctuantSphereEntity::new).func_220320_c().setShouldReceiveVelocityUpdates(true).func_220321_a(0.7f, 0.7f));
    public static final EntityType<SummonerEntity> SUMMONER = SkiesEntityTypes.buildEntity("summoner", EntityType.Builder.func_220322_a(SummonerEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 2.0f).func_220320_c());
    public static final EntityType<DecayingSpikeEntity> DECAYING_SPIKE = SkiesEntityTypes.buildEntity("decaying_spike", EntityType.Builder.func_220322_a(DecayingSpikeEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(DecayingSpikeEntity::new).setShouldReceiveVelocityUpdates(true).func_220320_c().func_220321_a(1.0f, 1.0f));
    public static final EntityType<AlchemistEntity> ALCHEMIST = SkiesEntityTypes.buildEntity("alchemist", EntityType.Builder.func_220322_a(AlchemistEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 2.0f).func_220320_c());

    public static void init(RegistryEvent.Register<EntityType<?>> event) {
        SkiesRegistry.register(event.getRegistry(), "azulfo", AZULFO);
        SkiesRegistry.register(event.getRegistry(), "stardust_ram", STARDUST_RAM);
        SkiesRegistry.register(event.getRegistry(), "reindeer", REINDEER);
        SkiesRegistry.register(event.getRegistry(), "frost_spirit", FROST_SPIRIT);
        SkiesRegistry.register(event.getRegistry(), "armored_frost_spirit", ARMORED_FROST_SPIRIT);
        SkiesRegistry.register(event.getRegistry(), "crynocerous", CRYNOCEROUS);
        SkiesRegistry.register(event.getRegistry(), "firefly", FIREFLY);
        SkiesRegistry.register(event.getRegistry(), "cosmic_fox", COSMIC_FOX);
        SkiesRegistry.register(event.getRegistry(), "crystal_camel", CRYSTAL_CAMEL);
        SkiesRegistry.register(event.getRegistry(), "nyctofly", NYCTOFLY);
        SkiesRegistry.register(event.getRegistry(), "venom_spider", VENOM_SPIDER);
        SkiesRegistry.register(event.getRegistry(), "venom_spit", VENOM_SPIT);
        SkiesRegistry.register(event.getRegistry(), "gatekeeper", GATEKEEPER);
        SkiesRegistry.register(event.getRegistry(), "artificial_golem", ARTIFICIAL_GOLEM);
        SkiesRegistry.register(event.getRegistry(), "strange_lightning", STRANGE_LIGHTNING);
        SkiesRegistry.register(event.getRegistry(), "fluctuant_sphere", FLUCTUANT_SPHERE);
        SkiesRegistry.register(event.getRegistry(), "summoner", SUMMONER);
        SkiesRegistry.register(event.getRegistry(), "decaying_spike", DECAYING_SPIKE);
        SkiesRegistry.register(event.getRegistry(), "alchemist", ALCHEMIST);
        SkiesEntityTypes.registerSpawnConditions();
    }

    private static <T extends Entity> EntityType<T> buildEntity(String key, EntityType.Builder<T> builder) {
        return builder.func_206830_a(BlueSkies.find(key));
    }

    private static boolean animalSpawnConditions(EntityType<? extends AnimalEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return (block == SkiesBlocks.turquoise_grass_block || block == SkiesBlocks.lunar_grass_block || block == SkiesBlocks.crystal_sand) && world.func_201669_a(pos, 0) > 8;
    }

    private static boolean mobSpawnConditions(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return (block == SkiesBlocks.turquoise_grass_block || block == SkiesBlocks.lunar_grass_block || block == SkiesBlocks.crystal_sand) && world.func_201669_a(pos, 0) > 8;
    }

    private static boolean monsterSpawnConditions(EntityType<? extends MobEntity> type, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return MobEntity.func_223315_a(type, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)rand) && rand.nextInt(200) == 0 && world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    private static void registerSpawnConditions() {
        EntitySpawnPlacementRegistry.func_209343_a(AZULFO, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::animalSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(STARDUST_RAM, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::animalSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(REINDEER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::animalSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(CRYSTAL_CAMEL, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::animalSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(COSMIC_FOX, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::animalSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(FIREFLY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::mobSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(ARMORED_FROST_SPIRIT, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::monsterSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(CRYNOCEROUS, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::monsterSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(NYCTOFLY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::monsterSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(VENOM_SPIDER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::monsterSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(GATEKEEPER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::mobSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(ARTIFICIAL_GOLEM, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::monsterSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(SUMMONER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::monsterSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(ALCHEMIST, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, SkiesEntityTypes::monsterSpawnConditions);
    }
}

