/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesRegistry;
import com.legacy.blue_skies.world.everbright.EverbrightDimension;
import com.legacy.blue_skies.world.everdawn.EverdawnDimension;
import io.netty.buffer.Unpooled;
import java.util.function.BiFunction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.RegistryEvent;

public class SkiesDimensions {
    private static ModDimension everbright = new ModDimension(){

        public BiFunction<World, DimensionType, ? extends Dimension> getFactory() {
            return EverbrightDimension::new;
        }
    };
    private static ModDimension everdawn = new ModDimension(){

        public BiFunction<World, DimensionType, ? extends Dimension> getFactory() {
            return EverdawnDimension::new;
        }
    };

    public static void init(RegistryEvent.Register<ModDimension> event) {
        SkiesRegistry.register(event.getRegistry(), "everbright", everbright);
        DimensionManager.registerDimension((ResourceLocation)BlueSkies.locate("everbright"), (ModDimension)everbright, (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)true);
        SkiesRegistry.register(event.getRegistry(), "everdawn", everdawn);
        DimensionManager.registerDimension((ResourceLocation)BlueSkies.locate("everdawn"), (ModDimension)everdawn, (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)true);
    }

    public static void initDimensions() {
        if (SkiesDimensions.everbrightType() == null) {
            DimensionManager.registerDimension((ResourceLocation)BlueSkies.locate("everbright"), (ModDimension)everbright, (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)true);
        }
        if (SkiesDimensions.everdawnType() == null) {
            DimensionManager.registerDimension((ResourceLocation)BlueSkies.locate("everdawn"), (ModDimension)everdawn, (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)true);
        }
    }

    public static DimensionType everbrightType() {
        DimensionType dimension = DimensionType.func_193417_a((ResourceLocation)BlueSkies.locate("everbright"));
        return dimension;
    }

    public static DimensionType everdawnType() {
        DimensionType dimension = DimensionType.func_193417_a((ResourceLocation)BlueSkies.locate("everdawn"));
        return dimension;
    }
}

