/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesRegistry;
import com.legacy.blue_skies.world.everbright.biomes.BrightlandsBiome;
import com.legacy.blue_skies.world.everbright.biomes.CalmingSkiesBiome;
import com.legacy.blue_skies.world.everbright.biomes.FrostbittenForestBiome;
import com.legacy.blue_skies.world.everbright.biomes.MiddayShoreBiome;
import com.legacy.blue_skies.world.everbright.biomes.PeekingOceanBiome;
import com.legacy.blue_skies.world.everbright.biomes.SlushlandsBiome;
import com.legacy.blue_skies.world.everdawn.biomes.CrystalDunesBiome;
import com.legacy.blue_skies.world.everdawn.biomes.RisingCreekBiome;
import com.legacy.blue_skies.world.everdawn.biomes.ShadedWoodlandsBiome;
import com.legacy.blue_skies.world.everdawn.biomes.SunsetMapleForestBiome;
import com.legacy.blue_skies.world.everdawn.biomes.UnorthodoxValleyBiome;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="blue_skies")
public class SkiesBiomes {
    public static final Biome CALMING_SKIES = new CalmingSkiesBiome();
    public static final Biome BRIGHTLANDS = new BrightlandsBiome();
    public static final Biome SLUSHLANDS = new SlushlandsBiome();
    public static final Biome FROSTBITTEN_FOREST = new FrostbittenForestBiome();
    public static final Biome PEEKING_OCEAN = new PeekingOceanBiome();
    public static final Biome MIDDAY_SHORE = new MiddayShoreBiome();
    public static final Biome UNORTHODOX_VALLEY = new UnorthodoxValleyBiome();
    public static final Biome SHADED_WOODLANDS = new ShadedWoodlandsBiome();
    public static final Biome CRYSTAL_DUNES = new CrystalDunesBiome();
    public static final Biome SUNSET_MAPLE_FOREST = new SunsetMapleForestBiome();
    public static final Biome RISING_CREEK = new RisingCreekBiome();
    public static List<Biome> EVERBRIGHT_BIOMES = Lists.newArrayList();
    public static List<Biome> EVERDAWN_BIOMES = Lists.newArrayList();

    public static void init(RegistryEvent.Register<Biome> event) {
        SkiesBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "calming_skies", CALMING_SKIES, true);
        SkiesBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "brightlands", BRIGHTLANDS, true);
        SkiesBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "slushlands", SLUSHLANDS, true);
        SkiesBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "frostbitten_forest", FROSTBITTEN_FOREST, true);
        SkiesBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "peeking_ocean", PEEKING_OCEAN, true);
        SkiesBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "midday_shore", MIDDAY_SHORE, true);
        SkiesBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "unorthodox_valley", UNORTHODOX_VALLEY, false);
        SkiesBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "shaded_woodlands", SHADED_WOODLANDS, false);
        SkiesBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "crystal_dunes", CRYSTAL_DUNES, false);
        SkiesBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "sunset_maple_forest", SUNSET_MAPLE_FOREST, false);
        SkiesBiomes.register((IForgeRegistry<Biome>)event.getRegistry(), "rising_creek", RISING_CREEK, false);
    }

    public static void register(IForgeRegistry<Biome> registry, String key, Biome biome, boolean inEverbright) {
        SkiesRegistry.register(registry, key, biome);
        if (inEverbright) {
            EVERBRIGHT_BIOMES.add((Biome)registry.getValue(BlueSkies.locate(key)));
        } else {
            EVERDAWN_BIOMES.add((Biome)registry.getValue(BlueSkies.locate(key)));
        }
    }
}

