/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.util;

import com.legacy.blue_skies.registries.SkiesItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.Items;

public class ToolHandleType {
    static List<ToolHandleType> toolHandleTypes = new ArrayList<ToolHandleType>();
    private final float durability;
    private final float attackSpeed;
    private final Item stick;
    private final int id;
    private final int color;
    private static int idCounter = 0;

    public ToolHandleType(float durability, float attackSpeed, Item stick, int color) {
        this.durability = durability;
        this.attackSpeed = attackSpeed;
        this.stick = stick;
        this.color = color;
        this.id = idCounter++;
    }

    public static ToolHandleType getHandleFromString(String name) {
        for (ToolHandleType t : toolHandleTypes) {
            if (!name.equals(t.getName())) continue;
            return t;
        }
        return toolHandleTypes.get(0);
    }

    public float getDurability() {
        return this.durability;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public Item getStick() {
        return this.stick;
    }

    public int getID() {
        return this.id;
    }

    public int getColor() {
        return this.color;
    }

    public String getName() {
        return this.getStick().getRegistryName().toString();
    }

    static {
        toolHandleTypes.add(new ToolHandleType(1.0f, 1.0f, Items.field_151055_y, Integer.parseInt("896727", 16)));
        toolHandleTypes.add(new ToolHandleType(1.0f, 1.0f, SkiesItems.bluebright_stick, Integer.parseInt("6171A2", 16)));
        toolHandleTypes.add(new ToolHandleType(1.0f, 1.0f, SkiesItems.lunar_stick, Integer.parseInt("9860AC", 16)));
        toolHandleTypes.add(new ToolHandleType(0.9f, 0.95f, SkiesItems.dusk_stick, Integer.parseInt("653C6C", 16)));
        toolHandleTypes.add(new ToolHandleType(0.9f, 0.95f, SkiesItems.starlit_stick, Integer.parseInt("92ADB2", 16)));
        toolHandleTypes.add(new ToolHandleType(1.1f, 1.05f, SkiesItems.frostbright_stick, Integer.parseInt("705045", 16)));
        toolHandleTypes.add(new ToolHandleType(1.1f, 1.05f, SkiesItems.maple_stick, Integer.parseInt("AB5745", 16)));
        toolHandleTypes.add(new ToolHandleType(1.2f, 1.05f, SkiesItems.cherry_stick, Integer.parseInt("B36371", 16)));
    }
}

