/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.util;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.function.Supplier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyLoadBase;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum SkiesArmorMaterial implements IArmorMaterial
{
    PYROPE("pyrope", 15, new int[]{1, 4, 5, 2}, 12, SoundEvents.field_187725_r, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{SkiesItems.pyrope_gem})),
    TURQUOISE("turquoise", 15, new int[]{2, 5, 6, 2}, 9, SoundEvents.field_187725_r, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{SkiesItems.turquoise_gem})),
    HORIZONITE("horizonite", 15, new int[]{1, 4, 5, 2}, 12, SoundEvents.field_187722_q, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{SkiesItems.horizonite_ingot})),
    DIOPSIDE("diopside", 15, new int[]{2, 5, 6, 2}, 9, SoundEvents.field_187725_r, 0.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{SkiesItems.diopside_gem})),
    CHAROITE("charoite", 33, new int[]{3, 6, 8, 3}, 10, SoundEvents.field_187716_o, 2.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{SkiesItems.charoite})),
    SHADOW("shadow", 33, new int[]{3, 6, 8, 3}, 10, SoundEvents.field_187716_o, 3.0f, () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{SkiesItems.charoite, Items.field_151045_i}));

    private static final int[] MAX_DAMAGE_ARRAY;
    private final String name;
    private final int maxDamageFactor;
    private final int[] damageReductionAmountArray;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final LazyLoadBase<Ingredient> repairMaterial;

    private SkiesArmorMaterial(String nameIn, int maxDamage, int[] damageReductionArray, int enchantability, SoundEvent equipSound, float toughness, Supplier<Ingredient> repairMaterial) {
        this.name = BlueSkies.find(nameIn);
        this.maxDamageFactor = maxDamage;
        this.damageReductionAmountArray = damageReductionArray;
        this.enchantability = enchantability;
        this.soundEvent = equipSound;
        this.toughness = toughness;
        this.repairMaterial = new LazyLoadBase(repairMaterial);
    }

    public int func_200896_a(EquipmentSlotType slotIn) {
        return MAX_DAMAGE_ARRAY[slotIn.func_188454_b()] * this.maxDamageFactor;
    }

    public int func_200902_b(EquipmentSlotType slotIn) {
        return this.damageReductionAmountArray[slotIn.func_188454_b()];
    }

    public int func_200900_a() {
        return this.enchantability;
    }

    public SoundEvent func_200899_b() {
        return this.soundEvent;
    }

    public Ingredient func_200898_c() {
        return (Ingredient)this.repairMaterial.func_179281_c();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_200897_d() {
        return this.name;
    }

    public float func_200901_e() {
        return this.toughness;
    }

    static {
        MAX_DAMAGE_ARRAY = new int[]{13, 15, 16, 11};
    }
}

