/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.util;

import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;

public interface IFalsiteCompat {
    public static final String falsite = "Falsite";

    default public <T extends LivingEntity> int damageItemFalsite(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int falsiteUses = IFalsiteCompat.getFalsiteUses(stack);
        if (falsiteUses > 0) {
            IFalsiteCompat.setFalsiteUses(stack, falsiteUses -= amount);
            if (falsiteUses <= 0) {
                onBroken.accept(entity);
                return Math.abs(falsiteUses);
            }
            return 0;
        }
        return amount;
    }

    public static ItemStack applyFalsite(ItemStack stackIn) {
        stackIn.func_196082_o().func_74768_a(falsite, IFalsiteCompat.getMaxFalsiteUses(stackIn));
        return stackIn;
    }

    public static int getMaxFalsiteUses(ItemStack stackIn) {
        return Math.max(Math.floorDiv(stackIn.func_77958_k(), 5), 10);
    }

    public static void setFalsiteUses(ItemStack stackIn, int value) {
        stackIn.func_196082_o().func_74768_a(falsite, Math.max(value, 0));
    }

    public static int getFalsiteUses(ItemStack stackIn) {
        return stackIn.func_196082_o().func_74762_e(falsite);
    }

    public boolean isCompatible();
}

