/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools;

import com.legacy.blue_skies.blocks.SkyPortalBlock;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class ZealLighterItem
extends FlintAndSteelItem {
    public ZealLighterItem(Item.Properties builder) {
        super(builder);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos pos;
        BlockPos face;
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        if (ZealLighterItem.canSetFire(world.func_180495_p(face = (pos = context.func_195995_a()).func_177972_a(context.func_196000_l())), (IWorld)world, face)) {
            world.func_184133_a(player, face, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            Block fire = ZealLighterItem.getFire((IWorld)world, face);
            world.func_180501_a(face, ((FireBlock)fire).func_196448_a((IBlockReader)world, pos), 11);
            ItemStack itemstack = context.func_195996_i();
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, face, itemstack);
                itemstack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(context.func_221531_n()));
            }
            return ActionResultType.SUCCESS;
        }
        BlockState affectedState = world.func_180495_p(pos);
        if (ZealLighterItem.func_219997_a((BlockState)affectedState)) {
            world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            world.func_180501_a(pos, (BlockState)affectedState.func_206870_a((IProperty)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(true)), 11);
            if (player != null) {
                context.func_195996_i().func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(context.func_221531_n()));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static boolean canSetFire(BlockState existingState, IWorld worldIn, BlockPos posIn) {
        BlockState fire = ((FireBlock)ZealLighterItem.getFire(worldIn, posIn)).func_196448_a((IBlockReader)worldIn, posIn);
        boolean flag = false;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            boolean nether = worldIn.func_180495_p(posIn.func_177972_a(direction)).func_177230_c() == Blocks.field_150343_Z && ((NetherPortalBlock)Blocks.field_150427_aO).func_201816_b(worldIn, posIn) != null;
            boolean bright = worldIn.func_180495_p(posIn.func_177972_a(direction)).func_177230_c() == SkiesBlocks.turquoise_stonebrick && ((SkyPortalBlock)SkiesBlocks.everbright_portal).func_201816_b(worldIn, posIn) != null;
            boolean dawn = worldIn.func_180495_p(posIn.func_177972_a(direction)).func_177230_c() == SkiesBlocks.lunar_stonebrick && ((SkyPortalBlock)SkiesBlocks.everdawn_portal).func_201816_b(worldIn, posIn) != null;
            DimensionType type = worldIn.func_201675_m().func_186058_p();
            if (!(type == DimensionType.field_223227_a_ && (nether || bright || dawn) || type == DimensionType.field_223228_b_ && nether || type == SkiesDimensions.everbrightType() && bright) && (type != SkiesDimensions.everdawnType() || !dawn)) continue;
            flag = true;
        }
        return existingState.isAir((IBlockReader)worldIn, posIn) && (fire.func_196955_c((IWorldReader)worldIn, posIn) || flag);
    }

    public static Block getFire(IWorld worldIn, BlockPos pos) {
        if (worldIn.func_201675_m().func_186058_p() == DimensionType.field_223227_a_ && ((SkyPortalBlock)SkiesBlocks.everbright_portal).isSkyPortal(worldIn, pos) != null) {
            return SkiesBlocks.blue_fire;
        }
        if (worldIn.func_201675_m().func_186058_p() == DimensionType.field_223227_a_ && ((SkyPortalBlock)SkiesBlocks.everdawn_portal).isSkyPortal(worldIn, pos) != null) {
            return SkiesBlocks.black_fire;
        }
        return worldIn.func_201675_m().func_186058_p() == SkiesDimensions.everbrightType() ? SkiesBlocks.blue_fire : (worldIn.func_201675_m().func_186058_p() == SkiesDimensions.everdawnType() ? SkiesBlocks.black_fire : Blocks.field_150480_ab);
    }
}

