/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.legacy.blue_skies.items.util.IFalsiteCompat;
import com.legacy.blue_skies.items.util.ToolHandleType;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeItem;

public class SkySwordItem
extends SwordItem
implements IForgeItem,
IFalsiteCompat {
    private final boolean falsiteCompat;
    private final float attackSpeed;

    public SkySwordItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        this(tier, attackDamageIn, attackSpeedIn, builder, false);
    }

    public SkySwordItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder, boolean falsiteCompat) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
        this.falsiteCompat = falsiteCompat;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this == SkiesItems.different_sword) {
            target.func_195064_c(new EffectInstance(Effects.field_76428_l, 40, 3));
        }
        return super.func_77644_a(stack, target, attacker);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> lore, ITooltipFlag flagIn) {
        if (this == SkiesItems.different_sword) {
            lore.add((ITextComponent)new TranslationTextComponent(String.format(TextFormatting.GOLD + I18n.func_135052_a((String)"gui.item.ability", (Object[])new Object[0]) + TextFormatting.WHITE + ": " + I18n.func_135052_a((String)"gui.item.ability.powerful", (Object[])new Object[0]), new Object[0]), new Object[0]));
            lore.add((ITextComponent)new TranslationTextComponent(String.format(TextFormatting.AQUA + I18n.func_135052_a((String)"gui.item.con", (Object[])new Object[0]) + TextFormatting.WHITE + ": " + I18n.func_135052_a((String)"gui.item.con.regen", (Object[])new Object[0]), new Object[0]), new Object[0]));
        } else if (this == SkiesItems.horizonite_sword) {
            lore.add((ITextComponent)new TranslationTextComponent(String.format(TextFormatting.GOLD + I18n.func_135052_a((String)"gui.item.ability", (Object[])new Object[0]) + TextFormatting.WHITE + ": " + I18n.func_135052_a((String)"gui.item.ability.fire", (Object[])new Object[0]), new Object[0]), new Object[0]));
        } else if (this == SkiesItems.mudkipz_sword) {
            lore.add((ITextComponent)new TranslationTextComponent(TextFormatting.GRAY + "This is a testing item, you should not have this in normal gameplay.", new Object[0]));
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolUtils.getToolDurability(this.func_200891_e(), stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.func_200894_d(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)ToolUtils.getToolSpeed(this.attackSpeed, stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_190903_i() {
        ItemStack stack = this.func_190903_i();
        stack.func_196082_o().func_74778_a("Stick", Items.field_151055_y.getRegistryName().toString());
        return stack;
    }

    public float getHandleValue(ItemStack stack) {
        String stick = stack.func_196082_o().func_74779_i("Stick");
        if (stick.equals("")) {
            stick = Items.field_151055_y.getRegistryName().toString();
        }
        return ToolHandleType.getHandleFromString(stick).getID();
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.falsiteCompat ? this.damageItemFalsite(stack, amount, entity, onBroken) : amount;
    }

    @Override
    public boolean isCompatible() {
        return this.falsiteCompat;
    }
}

