/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.legacy.blue_skies.items.util.IFalsiteCompat;
import com.legacy.blue_skies.items.util.ToolHandleType;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesItems;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeItem;

public class SkyHoeItem
extends HoeItem
implements IForgeItem,
IFalsiteCompat {
    private final boolean falsiteCompat;
    private final float attackSpeed;
    public static final Map<Block, BlockState> HOE_LOOKUP = new ImmutableMap.Builder().put((Object)SkiesBlocks.turquoise_grass_block, (Object)SkiesBlocks.turquoise_farmland.func_176223_P()).put((Object)SkiesBlocks.turquoise_dirt, (Object)SkiesBlocks.turquoise_farmland.func_176223_P()).put((Object)SkiesBlocks.coarse_turquoise_dirt, (Object)SkiesBlocks.turquoise_dirt.func_176223_P()).put((Object)SkiesBlocks.lunar_grass_block, (Object)SkiesBlocks.lunar_farmland.func_176223_P()).put((Object)SkiesBlocks.lunar_dirt, (Object)SkiesBlocks.lunar_farmland.func_176223_P()).put((Object)SkiesBlocks.coarse_lunar_dirt, (Object)SkiesBlocks.lunar_dirt.func_176223_P()).build();

    public SkyHoeItem(IItemTier tier, float attackSpeedIn, Item.Properties builder) {
        this(tier, attackSpeedIn, builder, false);
    }

    public SkyHoeItem(IItemTier tier, float attackSpeedIn, Item.Properties builder, boolean falsiteCompat) {
        super(tier, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
        this.falsiteCompat = falsiteCompat;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> lore, ITooltipFlag flagIn) {
        if (this == SkiesItems.horizonite_hoe) {
            lore.add((ITextComponent)new TranslationTextComponent(String.format(TextFormatting.GOLD + I18n.func_135052_a((String)"gui.item.ability", (Object[])new Object[0]) + TextFormatting.WHITE + ": " + I18n.func_135052_a((String)"gui.item.ability.smelt", (Object[])new Object[0]), new Object[0]), new Object[0]));
        }
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolUtils.getToolDurability(this.func_200891_e(), stack);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.0, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)ToolUtils.getToolSpeed(this.attackSpeed, stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_190903_i() {
        ItemStack stack = this.func_190903_i();
        stack.func_196082_o().func_74778_a("Stick", Items.field_151055_y.getRegistryName().toString());
        return stack;
    }

    public float getHandleValue(ItemStack stack) {
        String stick = stack.func_196082_o().func_74779_i("Stick");
        if (stick.equals("")) {
            stick = Items.field_151055_y.getRegistryName().toString();
        }
        return ToolHandleType.getHandleFromString(stick).getID();
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return this.falsiteCompat ? this.damageItemFalsite(stack, amount, entity, onBroken) : amount;
    }

    @Override
    public boolean isCompatible() {
        return this.falsiteCompat;
    }
}

