/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.events;

import com.legacy.blue_skies.blocks.SkyFireBlock;
import com.legacy.blue_skies.blocks.dungeon.KeystoneBlock;
import com.legacy.blue_skies.data.SkiesTags;
import com.legacy.blue_skies.entities.hostile.boss.AlchemistEntity;
import com.legacy.blue_skies.entities.hostile.boss.SummonerEntity;
import com.legacy.blue_skies.items.tools.SkyAxeItem;
import com.legacy.blue_skies.items.tools.SkyHoeItem;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SkiesPlayerEvents {
    @SubscribeEvent
    public void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        BlockRayTraceResult rayTraceResult = (BlockRayTraceResult)SkiesPlayerEvents.rayTrace(world, player);
        BlockPos pos = rayTraceResult.func_216350_a();
        if (event.getItemStack().func_77973_b() instanceof AxeItem) {
            BlockState blockState = world.func_180495_p(pos);
            Block block = SkyAxeItem.BLOCK_STRIPPING_MAP.get(blockState.func_177230_c());
            if (block != null) {
                player.func_130014_f_().func_184133_a(player, pos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(event.getHand());
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, (BlockState)block.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, blockState.func_177229_b((IProperty)RotatedPillarBlock.field_176298_M)), 11);
                    if (player != null) {
                        event.getItemStack().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getHand()));
                    }
                }
            }
            event.setCanceled(true);
        }
        if (event.getItemStack().func_77973_b() instanceof HoeItem) {
            BlockState dirtState = world.func_180495_p(pos);
            BlockState resultState = SkyHoeItem.HOE_LOOKUP.get(dirtState.func_177230_c());
            if (resultState != null && event.getFace() != Direction.DOWN && world.func_175623_d(pos.func_177984_a())) {
                player.func_130014_f_().func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
                player.func_184609_a(event.getHand());
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, resultState, 11);
                    if (player != null) {
                        event.getItemStack().func_222118_a(1, (LivingEntity)player, playerEntity -> playerEntity.func_213334_d(event.getHand()));
                    }
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerPunch(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pos;
        World world = event.getWorld();
        if (world.func_180495_p(pos = event.getPos().func_177972_a(event.getFace())).func_177230_c() == SkiesBlocks.blue_fire || world.func_180495_p(pos).func_177230_c() == SkiesBlocks.black_fire) {
            world.func_217379_c(1009, pos, 0);
            world.func_217377_a(pos, false);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onPlayerBreakWithHorizonite(PlayerEvent.HarvestCheck event) {
        if (SkiesTags.Items.HORIZONITE_TOOLS.func_199685_a_((Object)event.getPlayer().func_184614_ca().func_77973_b())) {
            event.setCanHarvest(false);
        }
    }

    @SubscribeEvent
    public void onSleepTimeCheck(SleepingTimeCheckEvent event) {
        if (event.getPlayer().field_71093_bK == SkiesDimensions.everbrightType() || event.getPlayer().field_71093_bK == SkiesDimensions.everdawnType()) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos clickPos;
        if (event.getPos() == null) {
            return;
        }
        World world = event.getWorld();
        if (!(world.func_180495_p((clickPos = new BlockPos((Vec3i)event.getPos())).func_177984_a()).func_177230_c() instanceof SkyFireBlock)) {
            return;
        }
        world.func_217379_c(1009, clickPos.func_177984_a(), 0);
        world.func_175656_a(clickPos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.func_180495_p(pos);
        PlayerEntity player = event.getPlayer();
        if (!this.inBossFight(player) || state.func_177230_c() instanceof KeystoneBlock) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onPlayerHarvestBlock(PlayerEvent.BreakSpeed event) {
        if (this.inBossFight(event.getPlayer())) {
            event.setNewSpeed(0.0f);
        }
    }

    private boolean inBossFight(PlayerEntity player) {
        AxisAlignedBB radiusCheck = new AxisAlignedBB(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_72314_b(25.0, 15.0, 25.0);
        List summonerList = player.field_70170_p.func_217357_a(SummonerEntity.class, radiusCheck);
        List alchemistList = player.field_70170_p.func_217357_a(AlchemistEntity.class, radiusCheck);
        return (!summonerList.isEmpty() || !alchemistList.isEmpty()) && !player.func_184812_l_();
    }

    private static RayTraceResult rayTrace(World worldIn, PlayerEntity player) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vec3d vec3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
        Vec3d vec3d1 = vec3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vec3d, vec3d1, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)player));
    }
}

